package ru.yandex.direct.core.entity.autobroker.service;

import javax.annotation.Nonnull;

import ru.yandex.direct.core.entity.autobroker.model.BrokerPrice;
import ru.yandex.direct.core.entity.keyword.model.Place;
import ru.yandex.direct.currency.Money;

/**
 * Связывает {@link BrokerPrice} (цены Автоброкера) с позициями {@link Place}.
 * <p>
 * Сейчас эта связка необходима только Автоброкеру. Поэтому package-private
 */
class AuctionPosition implements Comparable<AuctionPosition> {
    private final Place place;
    private final BrokerPrice brokerPrice;

    AuctionPosition(Place place, Money bidPrice, Money amnestyPrice) {
        this.place = place;
        this.brokerPrice = new BrokerPrice(bidPrice, amnestyPrice);
    }

    Place getPlace() {
        return place;
    }

    BrokerPrice getBrokerPrice() {
        return brokerPrice;
    }

    @Override
    public int compareTo(@Nonnull AuctionPosition o) {
        return Integer.compare(this.place.getCode(), (o.place.getCode()));
    }

    @Override
    public String toString() {
        return "(place=" + place.toString() + ";" + " brokerPrice=" + brokerPrice.toString() + ")";
    }
}
