package ru.yandex.direct.core.entity.autobroker.service;

import java.util.EnumSet;

/**
 * Описывает стратегию, заданную клиентом для ручной стратегии
 * <p>
 * Сейчас этот enum необходим только Автоброкеру. Поэтому package-private
 */
enum AuctionStrategyMode {

    HIGHEST_POSITION_ALL(EnumSet.of(Block.PREMIUM, Block.GUARANTEE)),
    HIGHEST_POSITION_GUARANTEE(EnumSet.of(Block.GUARANTEE));

    private EnumSet<Block> targetBlocks;

    AuctionStrategyMode(EnumSet<Block> targetBlocks) {
        this.targetBlocks = targetBlocks;
    }

    /**
     * @return {@code Set} с блоками, в которых требуется искать подходящее место.
     */
    public EnumSet<Block> getTargetBlocks() {
        return targetBlocks;
    }

    /**
     * Блок показа рекламного объявления на поиске.
     */
    enum Block {
        PREMIUM,
        GUARANTEE,
    }

    @Override
    public String toString() {
        return "targetBlocks: " + targetBlocks.toString();
    }
}
