package ru.yandex.direct.core.entity.autobudget.model;

import java.time.Duration;

/**
 * Параметры алертов автобюджета
 * <p>
 * При добавлении новых параметров - пожалуйста дублируйте их в perl-версии в хэше %ALERT_TYPE
 *
 * @see <a href="https://svn.yandex-team.ru/websvn/wsvn/direct/trunk/protected/AutobudgetAlerts.pm">AutobudgetAlerts</a>
 */
public class AutobudgetAlertProperties {

    public static final AutobudgetAlertProperties HOURLY =
            new AutobudgetAlertProperties(Duration.ofMinutes(70), Duration.ofDays(1));
    public static final AutobudgetAlertProperties CPA =
            new AutobudgetAlertProperties(Duration.ofHours(26), Duration.ofDays(2));

    private final Duration ttlForActiveAlerts;
    private final Duration ttlForFrozenAlerts;

    private AutobudgetAlertProperties(Duration ttlForActiveAlerts, Duration ttlForFrozenAlerts) {
        this.ttlForActiveAlerts = ttlForActiveAlerts;
        this.ttlForFrozenAlerts = ttlForFrozenAlerts;
    }

    /**
     * @return время с момента последнего обновления активного алерта, в течение которого он не должен быть удален
     */
    public Duration getTtlForActiveAlerts() {
        return ttlForActiveAlerts;
    }

    /**
     * @return время с момента последнего обновления замороженного алерта, в течение которого он не должен быть удален
     */
    public Duration getTtlForFrozenAlerts() {
        return ttlForFrozenAlerts;
    }
}
