package ru.yandex.direct.core.entity.autobudget.repository;

import java.util.BitSet;
import java.util.Set;

import org.jooq.types.UShort;

import ru.yandex.direct.core.entity.autobudget.model.AutobudgetCommonAlertStatus;
import ru.yandex.direct.core.entity.autobudget.model.AutobudgetForecastStatus;
import ru.yandex.direct.core.entity.autobudget.model.AutobudgetHourlyProblem;
import ru.yandex.direct.dbschema.ppc.enums.AutobudgetAlertsStatus;
import ru.yandex.direct.dbschema.ppc.enums.AutobudgetCpaAlertsStatus;
import ru.yandex.direct.dbschema.ppc.enums.AutobudgetForecastStatusautobudgetforecast;

import static com.google.common.base.Preconditions.checkState;

public class AutobudgetMapping {
    private AutobudgetMapping() {
    }

    public static AutobudgetAlertsStatus hourlyAlertsStatusToDb(AutobudgetCommonAlertStatus commonAlertStatus) {
        return commonAlertStatus != null ?
                AutobudgetAlertsStatus.valueOf(commonAlertStatus.name().toLowerCase()) : null;
    }

    public static AutobudgetCommonAlertStatus hourlyAlertsStatusFromDb(AutobudgetAlertsStatus hourlyAlertStatus) {
        return hourlyAlertStatus != null ?
                AutobudgetCommonAlertStatus.valueOf(hourlyAlertStatus.getLiteral().toUpperCase()) : null;
    }

    public static AutobudgetCpaAlertsStatus cpaAlertsStatusToDb(AutobudgetCommonAlertStatus commonAlertStatus) {
        return commonAlertStatus != null ?
                AutobudgetCpaAlertsStatus.valueOf(commonAlertStatus.name().toLowerCase()) : null;
    }

    public static AutobudgetCommonAlertStatus cpaAlertsStatusFromDb(AutobudgetCpaAlertsStatus cpaAlertStatus) {
        return cpaAlertStatus != null ?
                AutobudgetCommonAlertStatus.valueOf(cpaAlertStatus.getLiteral().toUpperCase()) : null;
    }

    public static AutobudgetForecastStatusautobudgetforecast autobudgetForecastStatusToDb(AutobudgetForecastStatus status) {
        if (status == null) {
            return null;
        }
        for (AutobudgetForecastStatusautobudgetforecast dbStatus : AutobudgetForecastStatusautobudgetforecast.values()) {
            if (dbStatus.name().equalsIgnoreCase(status.name())) {
                return dbStatus;
            }
        }
        return null;
    }

    public static AutobudgetForecastStatus autobudgetForecastStatusFromDb(AutobudgetForecastStatusautobudgetforecast status) {
        return status != null ?
                AutobudgetForecastStatus.valueOf(status.getLiteral().toUpperCase()) : null;
    }

    public static Set<AutobudgetHourlyProblem> problemsFromDb(UShort dbProblems) {
        BitSet bitset = BitSet.valueOf(new long[]{dbProblems.longValue()});

        return AutobudgetHourlyProblem.bitSetToEnumSet(bitset);
    }

    public static UShort problemsToDb(Set<AutobudgetHourlyProblem> problems) {
        if (problems.isEmpty()) {
            return UShort.valueOf(0);
        }
        long longResult = AutobudgetHourlyProblem.enumSetToBitSet(problems).toLongArray()[0];
        checkState(longResult >= UShort.MIN_VALUE && longResult <= UShort.MAX_VALUE);
        return UShort.valueOf((int) longResult);
    }
}
