package ru.yandex.direct.core.entity.autobudget.repository;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.ytwrapper.model.YtCluster;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Component
public class CpaAutobudgetClusterConfig {

    private final DirectConfig config;

    private CpaAutobudgetClusterConfig(DirectConfig directConfig) {
        this.config = directConfig.getBranch("cpa_autobudget_yt_sync");
    }

    public List<YtCluster> getClusters() {
        return mapList(config.getStringList("clusters"), YtCluster::parse);
    }
}
