package ru.yandex.direct.core.entity.autobudget.repository;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.autobudget.model.ConversionLevelToUpdate;
import ru.yandex.direct.core.entity.autobudget.model.GoalIdWithConversionLevel;
import ru.yandex.direct.ytwrapper.client.YtExecutionUtil;
import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.model.YtCluster;
import ru.yandex.direct.ytwrapper.model.YtTable;
import ru.yandex.misc.io.ClassPathResourceInputStreamSource;

import static ru.yandex.direct.core.entity.autobudget.ytmodels.generated.YtDbTables.GOALQUALITY;

@Repository
@ParametersAreNonnullByDefault
public class GoalQualityYtRepository extends AbstractAutobudgetYtRepository {

    private static final String GOAL_CONVERSIONS_TO_UPDATE_YQL_QUERY =
            String.join("\n", new ClassPathResourceInputStreamSource("cpaautobudget/GoalConversionsToUpdate.sql")
                    .readLines());

    @Autowired
    GoalQualityYtRepository(YtProvider ytProvider,
                            CpaAutobudgetClusterConfig config) {
        super(ytProvider, config);
    }

    @Override
    protected YtTable getTable() {
        return GOALQUALITY;
    }

    /**
     * Получить расходящиеся значения оценки конверсионности целей для metrika_goals (conversion_level) из таблицы
     * Goal Quality (//home/bs/goodgoals/v3/GoalQuality)
     */
    public List<GoalIdWithConversionLevel> getGoalsConversionLevelToUpdate(long limit) {
        List<YtCluster> clustersByPriority = getAvailableClustersOrdered();

        return YtExecutionUtil.executeWithFallback(clustersByPriority,
                ytProvider::getOperator,
                operator -> operator.yqlQuery(GOAL_CONVERSIONS_TO_UPDATE_YQL_QUERY, rs -> {
                    var goalId = rs.getLong("GoalID");
                    var conversionLevel = getConversionLevel(rs.getString("conversion_level"));
                    return new GoalIdWithConversionLevel()
                            .withId(goalId)
                            .withConversionLevelToUpdate(conversionLevel);
                }, limit)
        );
    }

    private static ConversionLevelToUpdate getConversionLevel(String conversionLevel) {
        switch (conversionLevel) {
            case "perfect":
                return ConversionLevelToUpdate.PERFECT;
            case "good":
                return ConversionLevelToUpdate.GOOD;
            case "soso":
                return ConversionLevelToUpdate.SOSO;
            case "bad":
                return ConversionLevelToUpdate.BAD;
        }

        return ConversionLevelToUpdate.UNKNOWN;
    }

}
