package ru.yandex.direct.core.entity.autobudget.service;

import java.util.Collection;
import java.util.Set;

public class AlertsFreezeInfo {
    private final Collection<Long> campaignsToFreezeHourlyAlerts;
    private final Collection<Long> campaignsToFreezeCpaAlerts;

    public AlertsFreezeInfo(Collection<Long> campaignsToFreezeHourlyAlerts, Collection<Long> campaignsToFreezeCpaAlerts) {
        this.campaignsToFreezeHourlyAlerts = campaignsToFreezeHourlyAlerts;
        this.campaignsToFreezeCpaAlerts = campaignsToFreezeCpaAlerts;
    }

    AlertsFreezeInfo(Collection<Long> campaignsToFreezeHourlyAlerts) {
        this.campaignsToFreezeHourlyAlerts = campaignsToFreezeHourlyAlerts;
        this.campaignsToFreezeCpaAlerts = Set.of();
    }

    public Set<Long> getCampaignsToFreezeHourlyAlerts() {
        return Set.copyOf(campaignsToFreezeHourlyAlerts);
    }

    public Set<Long> getCampaignsToFreezeCpaAlerts() {
        return Set.copyOf(campaignsToFreezeCpaAlerts);
    }
}
