package ru.yandex.direct.core.entity.autoprice.service;

import java.util.Collection;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.autoprice.repository.AutoPriceCampQueueRepository;
import ru.yandex.direct.dbschema.ppc.enums.AutoPriceCampQueueStatus;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.dbutil.sharding.ShardKey;

import static java.util.Collections.singletonList;

@Service
@ParametersAreNonnullByDefault
public class AutoPriceCampQueueService {
    public static final String CLEAR_ERROR = "phrases or bids already changed from interface/api";
    private final AutoPriceCampQueueRepository autoPriceCampQueueRepository;
    private final ShardHelper shardHelper;

    @Autowired
    public AutoPriceCampQueueService(AutoPriceCampQueueRepository autoPriceCampQueueRepository,
                                     ShardHelper shardHelper) {
        this.autoPriceCampQueueRepository = autoPriceCampQueueRepository;
        this.shardHelper = shardHelper;
    }

    /**
     * очищает очередь auto_price_camp_queue для переданных идентификаторов кампаний
     */
    public void clearAutoPriceQueue(Collection<Long> campaignIds) {
        shardHelper.groupByShard(campaignIds, ShardKey.CID)
                .forEach((shard, campsForShard) -> {
                    List<Long> campQueueIds = autoPriceCampQueueRepository
                            .getQueueIds(shard, campsForShard, singletonList(AutoPriceCampQueueStatus.Wait));
                    autoPriceCampQueueRepository.setErrorStatus(shard, campQueueIds, CLEAR_ERROR);
                });
    }
}
