package ru.yandex.direct.core.entity.banner;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.TranslationBundle;
import ru.yandex.direct.i18n.bundle.TranslationStub;

/**
 * Здесь объявляются переводы для сервиса баннеров для всего, кроме ошибок и предупреждений.
 * <p>
 * Переводы дефектов – в {@link ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectTranslations}.
 */
@ParametersAreNonnullByDefault
public interface BannerTranslations extends TranslationBundle {

    BannerTranslations INSTANCE = I18NBundle.implement(BannerTranslations.class);

    @TranslationStub("{Динамический заголовок}")
    Translatable dynamicTitle();

    @TranslationStub("{Перфоманс заголовок}")
    Translatable performanceTitle();

    @TranslationStub("{Перфоманс текст}")
    Translatable performanceBody();
}
