package ru.yandex.direct.core.entity.banner.container;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupForBannerOperation;
import ru.yandex.direct.core.entity.adgroup.model.ContentPromotionAdgroupType;
import ru.yandex.direct.core.entity.banner.model.Banner;
import ru.yandex.direct.core.entity.banner.model.ImageSize;
import ru.yandex.direct.core.entity.banner.model.ImageType;
import ru.yandex.direct.core.entity.banner.service.DatabaseMode;
import ru.yandex.direct.core.entity.banner.service.moderation.ModerationMode;
import ru.yandex.direct.core.entity.banner.service.validation.BannerValidationInfo;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithContentLanguage;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithMobileContent;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithStrategy;
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign;
import ru.yandex.direct.core.entity.client.model.Client;
import ru.yandex.direct.core.entity.clientphone.ClientPhoneIdsByTypeContainer;
import ru.yandex.direct.core.entity.creative.model.Creative;
import ru.yandex.direct.core.entity.image.model.BannerImageFormat;
import ru.yandex.direct.core.entity.mobileapp.model.MobileAppTracker;
import ru.yandex.direct.core.entity.organization.model.Organization;
import ru.yandex.direct.core.entity.pricepackage.model.PricePackage;
import ru.yandex.direct.core.entity.sitelink.model.SitelinkSet;
import ru.yandex.direct.core.entity.turbolanding.model.TurboLanding;
import ru.yandex.direct.core.entity.vcard.model.Vcard;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.rbac.RbacRole;

import static com.google.common.base.Preconditions.checkNotNull;
import static com.google.common.base.Preconditions.checkState;
import static java.util.Collections.emptyMap;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;
import static ru.yandex.direct.utils.FunctionalUtils.listToMap;

@ParametersAreNonnullByDefault
abstract class AbstractBannersOperationContainer implements BannersOperationContainer {

    private final int shard;

    private final Long operatorUid;
    private final RbacRole operatorRole;

    private final ClientId clientId;
    private final Long clientUid;
    private final Long chiefUid;
    private final Long clientRegionId;
    private final Set<String> clientEnabledFeatures;
    private Client client;

    private final ModerationMode moderationMode;

    private Map<Integer, AdGroupForBannerOperation> indexToAdGroupMap;
    private Supplier<Map<Integer, ContentPromotionAdgroupType>> indexToContentPromotionAdgroupTypeSupplier;
    private Map<Integer, CommonCampaign> indexToCampaignMap;

    // Id кампании -> информация о стратегии кампании
    // Если кампания не поддерживает стратегию, то в map'е не будет записи
    private Map<Long, CampaignWithStrategy> campaignIdToCampaignWithStrategyMap;
    private Map<Long, CampaignWithContentLanguage> campaignIdToCampaignWithContentLanguageMap;
    private Map<Long, CampaignWithMobileContent> campaignIdToCampaignWithMobileContentMap;
    private Map<Long, PricePackage> campaignIdToPricePackageMap = emptyMap();
    private Map<Long, Creative> creativeByIdMap;
    private IdentityHashMap<Banner, Creative> bannerToCreativeMap;

    private boolean cpmGeoProductAutoModeration;
    private boolean cpmGeoPinAutoModeration;

    private IdentityHashMap<Banner, Integer> bannerToIndexMap;
    private Map<Long, Organization> clientOrganizations;
    private Map<Long, Vcard> vcardIdToData;

    private Map<Long, SitelinkSet> sitelinkSets;

    private Map<Long, TurboLanding> turboLandings;

    private ClientPhoneIdsByTypeContainer phonesContainer;

    private Set<Long> accessibleOrganizationsPermalinkId;

    private Map<String, Pair<ImageType, ImageSize>> existingBigKingImageHashesWithType;
    private Map<String, Pair<ImageType, ImageSize>> existingImageTypesWithSizes;
    private Map<String, Pair<ImageType, ImageSize>> existingTypesWithSizesBeforeApply;
    private Map<String, BannerImageFormat> bannerImageFormats;

    private Map<Long, List<MobileAppTracker>> mobileAppIdToTrackersMap;

    private final boolean isOperatorInternal;
    private final boolean isPartOfComplexOperation;
    private final boolean validateTrackingHrefMacros;

    /**
     * Индекс добавляемого баннера -> информация о нём из комплексной операции.
     * Используется для валидации баннеров в рамках комплексной операции.
     */
    private Map<Integer, BannerValidationInfo> bannersValidationInfoMap;

    private DatabaseMode databaseMode;

    protected AbstractBannersOperationContainer(
            int shard,
            Long operatorUid,
            RbacRole operatorRole,
            ClientId clientId,
            Long clientUid,
            Long chiefUid,
            Long clientRegionId,
            Set<String> clientEnabledFeatures,
            ModerationMode moderationMode,
            boolean isOperatorInternal,
            boolean isPartOfComplexOperation,
            boolean validateTrackingHrefMacros) {
        this.shard = shard;
        this.operatorUid = operatorUid;
        this.operatorRole = operatorRole;
        this.clientId = clientId;
        this.clientUid = clientUid;
        this.chiefUid = chiefUid;
        this.clientRegionId = clientRegionId;
        this.clientEnabledFeatures = clientEnabledFeatures;
        this.moderationMode = moderationMode;

        this.isOperatorInternal = isOperatorInternal;
        this.isPartOfComplexOperation = isPartOfComplexOperation;
        this.validateTrackingHrefMacros = validateTrackingHrefMacros;
    }

    @Override
    public int getShard() {
        return shard;
    }

    @Override
    public Long getOperatorUid() {
        return operatorUid;
    }

    @Override
    public RbacRole getOperatorRole() {
        return operatorRole;
    }

    @Override
    public ClientId getClientId() {
        return clientId;
    }

    @Override
    public Long getClientUid() {
        return clientUid;
    }

    @Override
    public Long getChiefUid() {
        return chiefUid;
    }

    @Override
    public Long getClientRegionId() {
        return clientRegionId;
    }

    @Override
    public boolean isOperatorInternal() {
        return isOperatorInternal;
    }

    @Override
    public boolean isPartOfComplexOperation() {
        return isPartOfComplexOperation;
    }

    @Override
    public boolean isValidateTrackingHrefMacros() {
        return validateTrackingHrefMacros;
    }

    @Override
    public Set<String> getClientEnabledFeatures() {
        return clientEnabledFeatures;
    }

    @Override
    public Client getClient() {
        return client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    @Override
    public ModerationMode getModerationMode() {
        return moderationMode;
    }

    public void setIndexToAdGroupMap(
            Map<Integer, AdGroupForBannerOperation> indexToAdGroupMap) {
        checkState(this.indexToAdGroupMap == null, "indexToAdGroupMap is already set");
        this.indexToAdGroupMap = indexToAdGroupMap;
    }

    public boolean isIndexToAdGroupMapSet() {
        return indexToAdGroupMap != null;
    }

    private void checkIndexToAdGroupMapIsSet() {
        checkState(indexToAdGroupMap != null, "indexToAdGroupForOperationMap is not set yet");
    }

    @Override
    public Collection<AdGroupForBannerOperation> getAdGroups() {
        checkIndexToAdGroupMapIsSet();
        return indexToAdGroupMap.values();
    }

    @Override
    public Collection<AdGroupForBannerOperation> getUniqueAdGroups() {
        checkIndexToAdGroupMapIsSet();
        return StreamEx.of(indexToAdGroupMap.values())
                .distinct(AdGroupForBannerOperation::getId)
                .toList();
    }

    @Override
    @Nullable
    public AdGroupForBannerOperation getAdGroup(Banner banner) {
        checkIndexToAdGroupMapIsSet();
        Integer bannerIndex = getBannerIndex(banner);
        return indexToAdGroupMap.get(bannerIndex);
    }

    @Override
    @Nullable
    public Map<Integer, BannerValidationInfo> getBannersValidationInfoMap() {
        return bannersValidationInfoMap;
    }

    @Override
    @Nullable
    public BannerValidationInfo getBannersValidationInfo(Banner banner) {
        Integer bannerIndex = getBannerIndex(banner);
        return ifNotNull(bannersValidationInfoMap, map -> map.get(bannerIndex));
    }

    public void setBannersValidationInfoMap(Map<Integer, BannerValidationInfo> bannersValidationInfoMap) {
        this.bannersValidationInfoMap = bannersValidationInfoMap;
    }

    public void setIndexToContentPromotionAdgroupTypeMap(
            Supplier<Map<Integer, ContentPromotionAdgroupType>> indexToContentPromotionAdgroupTypeSupplier) {
        this.indexToContentPromotionAdgroupTypeSupplier = indexToContentPromotionAdgroupTypeSupplier;
    }

    public boolean isIndexToContentPromotionAdgroupTypeSupplierSet() {
        return indexToContentPromotionAdgroupTypeSupplier != null;
    }

    @Nullable
    public ContentPromotionAdgroupType getContentPromotionAdGroupType(Banner banner) {
        checkState(indexToContentPromotionAdgroupTypeSupplier != null,
                "indexToContentPromotionAdgroupTypeMap is not set yet");
        Integer bannerIndex = getBannerIndex(banner);
        return indexToContentPromotionAdgroupTypeSupplier.get().get(bannerIndex);
    }

    public void setIndexToCampaignMap(Map<Integer, CommonCampaign> indexToCampaignMap) {
        checkState(this.indexToCampaignMap == null, "indexToCampaignMap is already set");
        this.indexToCampaignMap = indexToCampaignMap;
    }

    private void checkIndexToCampaignMapIsSet() {
        checkNotNull(indexToCampaignMap, "indexToCampaignMap is not set yet");
    }

    @Override
    public Collection<CommonCampaign> getCampaigns() {
        checkIndexToCampaignMapIsSet();
        return indexToCampaignMap.values();
    }

    @Override
    public CommonCampaign getCampaign(Banner banner) {
        checkIndexToCampaignMapIsSet();
        Integer bannerIndex = getBannerIndex(banner);
        return indexToCampaignMap.get(bannerIndex);
    }

    public void setCampaignIdToCampaignWithStrategyMap(
            Map<Long, CampaignWithStrategy> campaignIdToCampaignWithStrategyMap) {
        checkState(this.campaignIdToCampaignWithStrategyMap == null,
                "campaignIdToCampaignWithStrategyMap is already set");
        this.campaignIdToCampaignWithStrategyMap = campaignIdToCampaignWithStrategyMap;
    }

    @Override
    public Map<Long, CampaignWithStrategy> getCampaignIdToCampaignWithStrategyMap() {
        checkNotNull(campaignIdToCampaignWithStrategyMap, "campaignIdToCampaignWithStrategyMap is not set yet");
        return campaignIdToCampaignWithStrategyMap;
    }

    @Override
    public Map<Long, PricePackage> getCampaignIdToPricePackageMap() {
        return campaignIdToPricePackageMap;
    }

    public AbstractBannersOperationContainer setCampaignIdToPricePackageMap(Map<Long, PricePackage> campaignIdToPricePackageMap) {
        this.campaignIdToPricePackageMap = campaignIdToPricePackageMap;
        return this;
    }

    public void setCampaignIdToCampaignWithContentLanguageMap(
            Map<Long, CampaignWithContentLanguage> campaignIdToCampaignWithContentLanguageMap) {
        checkState(this.campaignIdToCampaignWithContentLanguageMap == null,
                "campaignIdToCampaignWithContentLanguageMap is already set");
        this.campaignIdToCampaignWithContentLanguageMap = campaignIdToCampaignWithContentLanguageMap;
    }

    @Override
    public Map<Long, CampaignWithContentLanguage> getCampaignIdToCampaignWithContentLanguageMap() {
        checkNotNull(campaignIdToCampaignWithContentLanguageMap,
                "campaignIdToCampaignWithContentLanguageMap is not set yet");
        return campaignIdToCampaignWithContentLanguageMap;
    }

    public void setCampaignIdToCampaignWithMobileContentMap(
            Map<Long, CampaignWithMobileContent> campaignIdToCampaignWithMobileContentMap) {
        checkState(this.campaignIdToCampaignWithMobileContentMap == null,
                "campaignIdToCampaignWithMobileContentMap is already set");
        this.campaignIdToCampaignWithMobileContentMap = campaignIdToCampaignWithMobileContentMap;
    }

    @Override
    public Map<Long, CampaignWithMobileContent> getCampaignIdToCampaignWithMobileContentMap() {
        checkNotNull(campaignIdToCampaignWithMobileContentMap,
                "campaignIdToCampaignWithMobileContentMap is not set yet");
        return campaignIdToCampaignWithMobileContentMap;
    }

    @Override
    public Map<Long, Creative> getCreativeByIdMap() {
        checkNotNull(creativeByIdMap, "creativeByIdMap is not set yet");
        return creativeByIdMap;
    }

    public void setCreativeByIdMap(Map<Long, Creative> creativeByIdMap) {
        checkState(this.creativeByIdMap == null, "creativeByIdMap map already set");
        this.creativeByIdMap = creativeByIdMap;
    }

    @Override
    public IdentityHashMap<Banner, Creative> getBannerToCreativeMap() {
        checkNotNull(bannerToCreativeMap, "bannerToCreativeMap is not set yet");
        return bannerToCreativeMap;
    }

    public void setBannerToCreativeMap(IdentityHashMap<Banner, Creative> bannerToCreativeMap) {
        checkState(this.bannerToCreativeMap == null, "bannerToCreativeMap map already set");
        this.bannerToCreativeMap = bannerToCreativeMap;
    }

    @Override
    public Map<Long, Vcard> getVcardIdToData() {
        return vcardIdToData;
    }

    public void setVcardIdToData(Map<Long, Vcard> vcardIdToData) {
        this.vcardIdToData = vcardIdToData;
    }

    public void setCpmGeoProductAutoModeration(boolean cpmGeoProductAutoModeration) {
        this.cpmGeoProductAutoModeration = cpmGeoProductAutoModeration;
    }

    @Override
    public boolean isCpmGeoProductAutoModeration() {
        return cpmGeoProductAutoModeration;
    }

    public void setCpmGeoPinAutoModeration(boolean cpmGeoPinAutoModeration) {
        this.cpmGeoPinAutoModeration = cpmGeoPinAutoModeration;
    }

    @Override
    public boolean isCpmGeoPinAutoModeration() {
        return cpmGeoPinAutoModeration;
    }

    public void setBannerToIndexMap(IdentityHashMap<Banner, Integer> bannerToIndexMap) {
        checkState(this.bannerToIndexMap == null, "bannerToIndexMap is already set");
        this.bannerToIndexMap = bannerToIndexMap;
    }

    @Nullable
    private Integer getBannerIndex(Banner banner) {
        checkBannerToIndexMapIsSet();
        return bannerToIndexMap.get(banner);
    }

    public void setClientOrganizations(Map<Long, Organization> clientOrganizations) {
        this.clientOrganizations = clientOrganizations;
    }

    @Override
    public Map<Long, Organization> getClientOrganizations() {
        return clientOrganizations;
    }

    @Override
    public Map<Long, SitelinkSet> getSitelinkSets() {
        return sitelinkSets;
    }

    public void setSitelinkSets(List<SitelinkSet> sitelinkSets) {
        this.sitelinkSets = listToMap(sitelinkSets, SitelinkSet::getId);
    }

    @Override
    public Map<Long, TurboLanding> getTurboLandings() {
        return turboLandings;
    }

    public void setTurboLandings(Map<Long, TurboLanding> turboLandings) {
        this.turboLandings = turboLandings;
    }

    private void checkBannerToIndexMapIsSet() {
        checkNotNull(bannerToIndexMap, "bannerToIndexMap is not set yet");
    }

    public void setAllowedPhoneIds(ClientPhoneIdsByTypeContainer phonesContainer) {
        this.phonesContainer = phonesContainer;
    }

    @Override
    public ClientPhoneIdsByTypeContainer getAllowedPhoneIds() {
        return phonesContainer;
    }

    public Set<Long> getAccessibleOrganizationsPermalinkId() {
        return accessibleOrganizationsPermalinkId;
    }

    public void setAccessibleOrganizationsPermalinkId(Set<Long> accessibleOrganizationsPermalinkId) {
        this.accessibleOrganizationsPermalinkId = accessibleOrganizationsPermalinkId;
    }

    public void setExistingBigKingImageHashesWithType(Map<String, Pair<ImageType, ImageSize>> existingBigKingImageHashesWithType) {
        this.existingBigKingImageHashesWithType = existingBigKingImageHashesWithType;
    }

    @Override
    public Map<String, Pair<ImageType, ImageSize>> getExistingBigKingImageHashesWithType() {
        return this.existingBigKingImageHashesWithType;
    }

    public void setExistingImageTypesWithSizes(Map<String, Pair<ImageType, ImageSize>> imageTypesWithSizes) {
        this.existingImageTypesWithSizes = imageTypesWithSizes;
    }

    @Override
    public Map<String, Pair<ImageType, ImageSize>> getExistingImageTypesWithSizes() {
        return this.existingImageTypesWithSizes;
    }

    public void setExistingTypesWithSizesBeforeApply(Map<String, Pair<ImageType, ImageSize>> imageTypesWithSizes) {
        this.existingTypesWithSizesBeforeApply = imageTypesWithSizes;
    }

    @Override
    public Map<String, Pair<ImageType, ImageSize>> getExistingImageTypesWithSizesBeforeApply() {
        return this.existingTypesWithSizesBeforeApply;
    }

    @Override
    public Map<String, BannerImageFormat> getBannerImageFormats() {
        return bannerImageFormats;
    }

    public void setBannerImageFormats(Map<String, BannerImageFormat> bannerImageFormats) {
        this.bannerImageFormats = bannerImageFormats;
    }

    public void setMobileAppIdToTrackersMap(Map<Long, List<MobileAppTracker>> mobileAppIdToTrackersMap) {
        this.mobileAppIdToTrackersMap = mobileAppIdToTrackersMap;
    }

    @Override
    public Map<Long, List<MobileAppTracker>> getMobileAppIdToTrackersMap() {
        return this.mobileAppIdToTrackersMap;
    }

    public DatabaseMode getDatabaseMode() {
        return databaseMode;
    }

    public void setDatabaseMode(DatabaseMode databaseMode) {
        this.databaseMode = databaseMode;
    }
}
