package ru.yandex.direct.core.entity.banner.container;

import java.util.HashSet;
import java.util.Set;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.dbschema.ppc.enums.BannersBannerType;

import static java.util.Arrays.asList;
import static java.util.Collections.emptySet;

@ParametersAreNonnullByDefault
public class AdsCountCriteria {
    private Set<BannersBannerType> excludedTypes;

    @Nonnull
    public Set<BannersBannerType> getExcludedTypes() {
        return excludedTypes == null ? emptySet() : excludedTypes;
    }

    public AdsCountCriteria withExcludedTypes(@Nullable Set<BannersBannerType> adTypes) {
        this.excludedTypes = adTypes;
        return this;
    }

    public AdsCountCriteria withExcludedTypes(BannersBannerType... adTypes) {
        return withExcludedTypes(new HashSet<>(asList(adTypes)));
    }
}
