package ru.yandex.direct.core.entity.banner.container;

import java.util.HashSet;
import java.util.Set;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.YesNo;
import ru.yandex.direct.core.entity.adgroup.model.ContentPromotionAdgroupType;
import ru.yandex.direct.core.entity.banner.model.ExtensionStatus;
import ru.yandex.direct.core.entity.banner.model.State;
import ru.yandex.direct.core.entity.banner.model.Status;
import ru.yandex.direct.dbschema.ppc.enums.BannersBannerType;

import static java.util.Arrays.asList;
import static java.util.Collections.emptySet;
import static ru.yandex.direct.utils.CommonUtils.nvl;

@ParametersAreNonnullByDefault
public class AdsSelectionCriteria {

    private Set<Long> adIds;
    private Set<Long> adGroupIds;
    private Set<Long> campaignIds;
    private Set<State> states;
    private Set<Status> statuses;
    private Set<BannersBannerType> types;
    private YesNo mobile;
    private Set<Long> vcardIds;
    private Set<Long> sitelinkSetIds;
    private Set<String> adImageHashes;
    private Set<ExtensionStatus> vcardStatuses;
    private Set<ExtensionStatus> sitelinksStatuses;
    private Set<ExtensionStatus> adImageStatuses;
    private Set<Long> adExtensionIds;
    private Boolean selectCpmVideo;
    private Boolean selectCpmBanner;
    private Set<ContentPromotionAdgroupType> contentPromotionAdgroupTypes;

    @Nonnull
    public Boolean selectCpmVideo() {
        return selectCpmVideo;
    }

    public AdsSelectionCriteria withSelectCpmVideo(@Nonnull Boolean selectCpmVideo) {
        this.selectCpmVideo = selectCpmVideo;
        return this;
    }

    @Nonnull
    public Boolean selectCpmBanner() {
        return selectCpmBanner;
    }

    public AdsSelectionCriteria withSelectCpmBanner(@Nonnull Boolean selectCpmBanner) {
        this.selectCpmBanner = selectCpmBanner;
        return this;
    }

    @Nonnull
    public Set<ContentPromotionAdgroupType> getContentPromotionAdgroupTypes() {
        return nvl(contentPromotionAdgroupTypes, emptySet());
    }

    public AdsSelectionCriteria withContentPromotionAdgroupTypes(
            Set<ContentPromotionAdgroupType> contentPromotionAdgroupTypes) {
        this.contentPromotionAdgroupTypes = contentPromotionAdgroupTypes;
        return this;
    }

    @Nonnull
    public Set<Long> getAdIds() {
        return adIds == null ? emptySet() : adIds;
    }

    public AdsSelectionCriteria withAdIds(@Nullable Set<Long> adIds) {
        this.adIds = adIds;
        return this;
    }

    public AdsSelectionCriteria withAdIds(Long... adIds) {
        withAdIds(new HashSet<>(asList(adIds)));
        return this;
    }

    @Nonnull
    public Set<Long> getAdGroupIds() {
        return adGroupIds == null ? emptySet() : adGroupIds;
    }

    public AdsSelectionCriteria withAdGroupIds(@Nullable Set<Long> adGroupIds) {
        this.adGroupIds = adGroupIds;
        return this;
    }

    public AdsSelectionCriteria withAdGroupIds(Long... adGroupIds) {
        withAdGroupIds(new HashSet<>(asList(adGroupIds)));
        return this;
    }

    @Nonnull
    public Set<Long> getCampaignIds() {
        return campaignIds == null ? emptySet() : campaignIds;
    }

    public AdsSelectionCriteria withCampaignIds(@Nullable Set<Long> campaignIds) {
        this.campaignIds = campaignIds;
        return this;
    }

    public AdsSelectionCriteria withCampaignIds(Long... adGroupIds) {
        withCampaignIds(new HashSet<>(asList(adGroupIds)));
        return this;
    }

    @Nonnull
    public Set<State> getStates() {
        return states == null ? emptySet() : states;
    }

    public AdsSelectionCriteria withStates(@Nullable Set<State> states) {
        this.states = states;
        return this;
    }

    public AdsSelectionCriteria withStates(State... states) {
        withStates(new HashSet<>(asList(states)));
        return this;
    }

    @Nonnull
    public Set<Status> getStatuses() {
        return statuses == null ? emptySet() : statuses;
    }

    public AdsSelectionCriteria withStatuses(@Nullable Set<Status> statuses) {
        this.statuses = statuses;
        return this;
    }

    public AdsSelectionCriteria withStatuses(Status... statuses) {
        withStatuses(new HashSet<>(asList(statuses)));
        return this;
    }

    @Nonnull
    public Set<BannersBannerType> getTypes() {
        return types == null ? emptySet() : types;
    }

    public AdsSelectionCriteria withTypes(@Nullable Set<BannersBannerType> adTypes) {
        this.types = adTypes;
        return this;
    }

    public AdsSelectionCriteria withTypes(BannersBannerType... adTypes) {
        withTypes(new HashSet<>(asList(adTypes)));
        return this;
    }

    public YesNo getMobile() {
        return mobile;
    }

    public AdsSelectionCriteria withMobile(@Nullable YesNo isMobile) {
        this.mobile = isMobile;
        return this;
    }

    @Nonnull
    public Set<Long> getVCardIds() {
        return vcardIds == null ? emptySet() : vcardIds;
    }

    public AdsSelectionCriteria withVCardIds(@Nullable Set<Long> vcardIds) {
        this.vcardIds = vcardIds;
        return this;
    }

    public AdsSelectionCriteria withVCardIds(Long... vcardIds) {
        withVCardIds(new HashSet<>(asList(vcardIds)));
        return this;
    }

    @Nonnull
    public Set<Long> getSitelinkSetIds() {
        return sitelinkSetIds == null ? emptySet() : sitelinkSetIds;
    }

    public AdsSelectionCriteria withSitelinkSetIds(@Nullable Set<Long> sitelinkSetIds) {
        this.sitelinkSetIds = sitelinkSetIds;
        return this;
    }

    public AdsSelectionCriteria withSitelinkSetIds(Long... sitelinkSetIds) {
        withSitelinkSetIds(new HashSet<>(asList(sitelinkSetIds)));
        return this;
    }

    @Nonnull
    public Set<String> getAdImageHashes() {
        return adImageHashes == null ? emptySet() : adImageHashes;
    }

    public AdsSelectionCriteria withAdImageHashes(@Nullable Set<String> adImageHashes) {
        this.adImageHashes = adImageHashes;
        return this;
    }

    public AdsSelectionCriteria withAdImageHashes(String... adImageHashes) {
        withAdImageHashes(new HashSet<>(asList(adImageHashes)));
        return this;
    }

    @Nonnull
    public Set<ExtensionStatus> getVCardStatuses() {
        return vcardStatuses == null ? emptySet() : vcardStatuses;
    }

    public AdsSelectionCriteria withVCardStatuses(@Nullable Set<ExtensionStatus> vcardStatuses) {
        this.vcardStatuses = vcardStatuses;
        return this;
    }

    public AdsSelectionCriteria withVCardStatuses(ExtensionStatus... vcardStatuses) {
        withVCardStatuses(new HashSet<>(asList(vcardStatuses)));
        return this;
    }

    @Nonnull
    public Set<ExtensionStatus> getSitelinksStatuses() {
        return sitelinksStatuses == null ? emptySet() : sitelinksStatuses;
    }

    public AdsSelectionCriteria withSitelinksStatuses(@Nullable Set<ExtensionStatus> sitelinksStatuses) {
        this.sitelinksStatuses = sitelinksStatuses;
        return this;
    }

    public AdsSelectionCriteria withSitelinksStatuses(ExtensionStatus... sitelinksStatuses) {
        withSitelinksStatuses(new HashSet<>(asList(sitelinksStatuses)));
        return this;
    }

    @Nonnull
    public Set<ExtensionStatus> getAdImageStatuses() {
        return adImageStatuses == null ? emptySet() : adImageStatuses;
    }

    public AdsSelectionCriteria withAdImageStatuses(@Nullable Set<ExtensionStatus> adImageStatuses) {
        this.adImageStatuses = adImageStatuses;
        return this;
    }

    public AdsSelectionCriteria withAdImageStatuses(ExtensionStatus... adImageStatuses) {
        withAdImageStatuses(new HashSet<>(asList(adImageStatuses)));
        return this;
    }

    @Nonnull
    public Set<Long> getAdExtensionIds() {
        return adExtensionIds == null ? emptySet() : adExtensionIds;
    }

    public AdsSelectionCriteria withAdExtensionIds(@Nullable Set<Long> adExtensionIds) {
        this.adExtensionIds = adExtensionIds;
        return this;
    }

    public AdsSelectionCriteria withAdExtensionIds(Long... adExtensionIds) {
        withAdExtensionIds(new HashSet<>(asList(adExtensionIds)));
        return this;
    }
}
