package ru.yandex.direct.core.entity.banner.container;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableSet;

import ru.yandex.direct.core.entity.banner.model.Banner;
import ru.yandex.direct.core.entity.banner.type.flags.BannerUserFlagsUpdateInfo;
import ru.yandex.direct.dbutil.model.ClientId;

/**
 * Контейнер с данными, для выполнения дополнительных действий в операциях баннеров.
 * Например для сброса статуса синхронизации с БК для групп
 */
@ParametersAreNonnullByDefault
public class BannerAdditionalActionsContainer {

    private final Set<Long> adGroupIdsForRemoderation = new HashSet<>();

    // Мы делаем bsResync на некоторые (не все) группы находящиеся в draftPerformanceAdGroupAsModerated. Но если группа
    // попадёт одновременно и в adGroupsIdsForBSResync - сделаем bsResync дважды, это не оптимально.
    private final Set<Long> draftPerformanceAdGroupAsModerated = new HashSet<>();

    private final Set<Long> campaignIdsForRemoderation = new HashSet<>();
    private final Set<Long> campaignIdsForRemoderationForContentPromotion = new HashSet<>();
    private final Set<Long> adGroupsIdsForBSResync = new HashSet<>();
    private final Set<Long> adGroupsIdsForSettingBlProcessing = new HashSet<>();
    private final Set<Long> creativeIdsToModerate = new HashSet<>();
    private final Set<Long> creativeIdsToSetGeo = new HashSet<>();
    private final List<Banner> bannersToClearModerationFlags = new ArrayList<>();
    private final List<BannerUserFlagsUpdateInfo> bannerUserFlagsUpdates = new ArrayList<>();


    private final ClientId clientId;
    private final @Nullable Long clientRegionId;

    public BannerAdditionalActionsContainer(ClientId clientId, @Nullable Long clientRegionId) {
        this.clientId = clientId;
        this.clientRegionId = clientRegionId;
    }

    public ClientId getClientId() {
        return clientId;
    }

    @Nullable
    public Long getClientRegionId() {
        return clientRegionId;
    }

    public void addAdGroupIdForRemoderation(Long adGroupId) {
        adGroupIdsForRemoderation.add(adGroupId);
    }

    public void removeAdGroupIdFromRemoderation(Long adGroupId) {
        adGroupIdsForRemoderation.remove(adGroupId);
    }

    public void addAdGroupIdsForRemoderation(Collection<Long> adGroupIds) {
        adGroupIdsForRemoderation.addAll(adGroupIds);
    }

    public void addCampaignIdForRemoderation(Long campaignId) {
        campaignIdsForRemoderation.add(campaignId);
    }

    public void removeCampaignIdFromRemoderation(Long campaignId) {
        campaignIdsForRemoderation.remove(campaignId);
    }

    public void addCampaignIdsForRemoderation(Collection<Long> campaignIds) {
        campaignIdsForRemoderation.addAll(campaignIds);
    }

    public void addCampaignIdForRemoderationForContentPromotion(Long campaignId) {
        campaignIdsForRemoderationForContentPromotion.add(campaignId);
    }

    public void addCampaignIdsForRemoderationForContentPromotion(Collection<Long> campaignIds) {
        campaignIdsForRemoderationForContentPromotion.addAll(campaignIds);
    }

    public void addBannerToClearModerationFlags(Banner banner) {
        bannersToClearModerationFlags.add(banner);
    }

    public void removeBannerToClearModerationFlags(Banner banner) {
        bannersToClearModerationFlags.remove(banner);
    }

    public List<Banner> getBannersToClearModerationFlags() {
        return bannersToClearModerationFlags;
    }

    public void addCreativeIdToModerate(Long creativeId) {
        creativeIdsToModerate.add(creativeId);
    }

    public void addCreativeIdsToModerate(Collection<Long> creativeIds) {
        creativeIdsToModerate.addAll(creativeIds);
    }

    public void addCreativeIdToSetGeo(Long creativeId) {
        creativeIdsToSetGeo.add(creativeId);
    }

    public void addCreativeIdsToSetGeo(Collection<Long> creativeIds) {
        creativeIdsToSetGeo.addAll(creativeIds);
    }

    public Set<Long> getAdGroupIdsForRemoderation() {
        return ImmutableSet.copyOf(adGroupIdsForRemoderation);
    }

    public Set<Long> getCampaignIdsForRemoderation() {
        return ImmutableSet.copyOf(campaignIdsForRemoderation);
    }

    public Set<Long> getCampaignIdsForRemoderationForContentPromotion() {
        return ImmutableSet.copyOf(campaignIdsForRemoderationForContentPromotion);
    }

    public Set<Long> getAdGroupsIdsForBSResync() {
        return adGroupsIdsForBSResync;
    }

    public void addAdGroupIdForBSResync(Long idForBSResync) {
        adGroupsIdsForBSResync.add(idForBSResync);
    }

    public void addAdGroupsIdsForBSResync(Collection<Long> idsForBSResync) {
        this.adGroupsIdsForBSResync.addAll(idsForBSResync);
    }

    public Set<Long> getAdGroupsIdsForSettingBlProcessing() {
        return adGroupsIdsForSettingBlProcessing;
    }

    public void addAdGroupIdForSettingBlProcessing(Long idForForSettingBlProcessing) {
        adGroupsIdsForSettingBlProcessing.add(idForForSettingBlProcessing);
    }

    public void addAdGroupsIdsForForSettingBlProcessing(Collection<Long> idsForForSettingBlProcessing) {
        this.adGroupsIdsForSettingBlProcessing.addAll(idsForForSettingBlProcessing);
    }

    public Set<Long> getCreativeIdsToModerate() {
        return creativeIdsToModerate;
    }

    public Set<Long> getCreativeIdsToSetGeo() {
        return creativeIdsToSetGeo;
    }

    public void addDraftPerformanceAdGroupAsModerated(Long adGroupId) {
        draftPerformanceAdGroupAsModerated.add(adGroupId);
    }

    public void addDraftPerformanceAdGroupsAsModerated(Collection<Long> adGroupIds) {
        draftPerformanceAdGroupAsModerated.addAll(adGroupIds);
    }

    public Set<Long> getDraftPerformanceAdGroupAsModerated() {
        return draftPerformanceAdGroupAsModerated;
    }

    public void addBannerUserFlagsUpdate(BannerUserFlagsUpdateInfo bannerUserFlagsUpdate) {
        bannerUserFlagsUpdates.add(bannerUserFlagsUpdate);
    }

    public List<BannerUserFlagsUpdateInfo> getBannerUserFlagsUpdates() {
        return bannerUserFlagsUpdates;
    }
}
