package ru.yandex.direct.core.entity.banner.container;

import java.util.Map;
import java.util.function.Function;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupForBannerOperation;
import ru.yandex.direct.core.entity.banner.model.BannerWithOrganizationAndPhone;
import ru.yandex.direct.core.entity.clientphone.ClientPhoneIdsByTypeContainer;
import ru.yandex.direct.model.AppliedChanges;

@ParametersAreNonnullByDefault
public class BannerOperationContainerUtils {

    public static Map<Long, AdGroupForBannerOperation> getAdGroupIdToAdGroup(BannersOperationContainer container) {
        return StreamEx.of(container.getUniqueAdGroups())
                .mapToEntry(AdGroupForBannerOperation::getId, Function.identity())
                .toMap();
    }


    public static boolean needToCheckPermalinkAccessForAdd(
            BannerWithOrganizationAndPhone bannerWithOrganization,
            ClientPhoneIdsByTypeContainer phoneIdsContainer,
            BannersOperationContainer bannersContainer,
            boolean allowOverrideNotManual
    ) {
        Long newPhoneId = bannerWithOrganization.getPhoneId();
        return needToCheckPermalinkAccess(bannerWithOrganization, bannersContainer) &&
                needToCheckPermalinkAccess(newPhoneId, phoneIdsContainer, allowOverrideNotManual);
    }

    public static boolean needToCheckPermalinkAccessForUpdate(
            AppliedChanges<BannerWithOrganizationAndPhone> ac,
            ClientPhoneIdsByTypeContainer phoneIdsContainer,
            BannersOperationContainer bannersContainer,
            boolean allowOverrideNotManual
    ) {
        if (!needToCheckPermalinkAccess(ac.getModel(), bannersContainer)) {
            return false;
        }
        if (ac.changedAndNotDeleted(BannerWithOrganizationAndPhone.PHONE_ID) ||
                ac.changedAndNotDeleted(BannerWithOrganizationAndPhone.PERMALINK_ID)
        ) {
            Long newPhoneId = ac.getNewValue(BannerWithOrganizationAndPhone.PHONE_ID);
            return needToCheckPermalinkAccess(newPhoneId, phoneIdsContainer, allowOverrideNotManual);
        }
        return false;
    }

    public static boolean needToCheckPermalinkAccess(BannerWithOrganizationAndPhone banner,
                                                     BannersOperationContainer container) {
        return !container.isUniversalCampaignBanner(banner) || container.isUcPreValidation();
    }

    public static boolean needToCheckPermalinkAccess(
            @Nullable Long phoneId,
            ClientPhoneIdsByTypeContainer container,
            boolean allowOverrideNotManual
    ) {
        return phoneId != null
                && (!allowOverrideNotManual || container.getManualPhoneIds().contains(phoneId));
    }
}
