package ru.yandex.direct.core.entity.banner.container;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupForBannerOperation;
import ru.yandex.direct.core.entity.banner.model.Banner;
import ru.yandex.direct.core.entity.banner.service.validation.BannerValidationInfo;
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.feature.FeatureName;

/**
 * Интерфейс контейнера необходимый для валидации пикселей
 */
@ParametersAreNonnullByDefault
public interface BannerWithPixelsValidationContainer {

    int getShard();

    ClientId getClientId();

    Collection<CommonCampaign> getCampaigns();

    Collection<AdGroupForBannerOperation> getAdGroups();

    /**
     * Информация о группе.
     * Может вернуть null в следующем случае:
     * При добавлении баннера указанный id группы ссылается на группу, отсутствующую у клиента
     */
    @Nullable
    AdGroupForBannerOperation getAdGroup(Banner banner);

    /**
     * Получить список уникальных групп.
     * В {@link #getAdGroups()} могут храниться дубли групп.
     */
    Collection<AdGroupForBannerOperation> getUniqueAdGroups();

    @Nullable
    BannerValidationInfo getBannersValidationInfo(Banner banner);

    Set<String> getClientEnabledFeatures();


    /**
     * Индекс добавляемого баннера -> информация о нём из комплексной операции.
     */
    @Nullable
    Map<Integer, BannerValidationInfo> getBannersValidationInfoMap();

    CommonCampaign getCampaign(Banner banner);

    boolean isFeatureEnabledForClient(FeatureName featureName);
}
