package ru.yandex.direct.core.entity.banner.container;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jetbrains.annotations.Nullable;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupForBannerOperation;
import ru.yandex.direct.core.entity.banner.model.Banner;
import ru.yandex.direct.core.entity.banner.service.validation.BannerValidationInfo;
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.feature.FeatureName;

/**
 * Адаптер для BannersOperationContainer для работы через интерфейс BannerWithPixelsValidationContainer
 */
@ParametersAreNonnullByDefault
public class BannerWithPixelsValidationContainerBannerOperationAdapter implements BannerWithPixelsValidationContainer {

    private final BannersOperationContainer bannersOperationContainer;

    public BannerWithPixelsValidationContainerBannerOperationAdapter(BannersOperationContainer bannersOperationContainer) {
        this.bannersOperationContainer = bannersOperationContainer;
    }

    @Override
    public int getShard() {
        return bannersOperationContainer.getShard();
    }

    @Override
    public ClientId getClientId() {
        return bannersOperationContainer.getClientId();
    }

    @Override
    public Collection<CommonCampaign> getCampaigns() {
        return bannersOperationContainer.getCampaigns();
    }

    @Override
    public Collection<AdGroupForBannerOperation> getAdGroups() {
        return bannersOperationContainer.getAdGroups();
    }

    @Nullable
    @Override
    public AdGroupForBannerOperation getAdGroup(Banner banner) {
        return bannersOperationContainer.getAdGroup(banner);
    }

    @Override
    public Collection<AdGroupForBannerOperation> getUniqueAdGroups() {
        return bannersOperationContainer.getUniqueAdGroups();
    }

    @Nullable
    @Override
    public BannerValidationInfo getBannersValidationInfo(Banner banner) {
        return bannersOperationContainer.getBannersValidationInfo(banner);
    }

    @Override
    public Set<String> getClientEnabledFeatures() {
        return bannersOperationContainer.getClientEnabledFeatures();
    }

    @Nullable
    @Override
    public Map<Integer, BannerValidationInfo> getBannersValidationInfoMap() {
        return bannersOperationContainer.getBannersValidationInfoMap();
    }

    @Override
    public CommonCampaign getCampaign(Banner banner) {
        return bannersOperationContainer.getCampaign(banner);
    }

    @Override
    public boolean isFeatureEnabledForClient(FeatureName featureName) {
        return bannersOperationContainer.isFeatureEnabledForClient(featureName);
    }
}
