package ru.yandex.direct.core.entity.banner.container;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.direct.core.entity.banner.service.BannersAddOperation;

/**
 * Контейнер для {@link BannersAddOperation}
 */
@ParametersAreNonnullByDefault
public interface BannersAddOperationContainer extends BannersOperationContainer {

    boolean isAdGroupExternal();

    boolean isCopy();

    @Nullable
    Set<Integer> getBannersWithUnreachableUrlIndexes();

    void setBannersWithUnreachableUrlIndexes(@NotNull Set<Integer> indexes);
}
