package ru.yandex.direct.core.entity.banner.container;

import java.util.Set;

import org.jetbrains.annotations.NotNull;

import ru.yandex.direct.core.entity.banner.model.Banner;
import ru.yandex.direct.core.entity.banner.service.moderation.ModerationMode;
import ru.yandex.direct.core.entity.campaign.AvailableCampaignSources;
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.rbac.RbacRole;

import static com.google.common.base.Preconditions.checkState;

public class BannersAddOperationContainerImpl extends AbstractBannersOperationContainer
        implements BannersAddOperationContainer {

    private boolean isAdGroupExternal = false;
    private boolean isCopy = false;
    private boolean isFromApi = false;
    private boolean isUcPreValidation = false;

    private Set<Integer> bannersWithUnreachableUrlIndexes;

    public BannersAddOperationContainerImpl(int shard,
                                            Long operatorUid,
                                            RbacRole operatorRole,
                                            ClientId clientId,
                                            Long clientUid,
                                            Long chiefUid,
                                            Long clientRegionId,
                                            Set<String> clientEnabledFeatures,
                                            ModerationMode moderationMode,
                                            boolean isOperatorInternal,
                                            boolean isPartOfComplexOperation,
                                            boolean validateTrackingHrefMacros) {
        super(shard, operatorUid, operatorRole, clientId, clientUid, chiefUid, clientRegionId, clientEnabledFeatures,
                moderationMode, isOperatorInternal, isPartOfComplexOperation, validateTrackingHrefMacros);
    }

    @Override
    public Set<Integer> getBannersWithUnreachableUrlIndexes() {
        return bannersWithUnreachableUrlIndexes;
    }

    @Override
    public void setBannersWithUnreachableUrlIndexes(@NotNull Set<Integer> indexes) {
        checkState(this.bannersWithUnreachableUrlIndexes == null, "bannersWithUnreachableUrlIndexes are already set");
        this.bannersWithUnreachableUrlIndexes = indexes;
    }

    @Override
    public boolean isAdGroupExternal() {
        return isAdGroupExternal;
    }

    public void setAdGroupExternal(boolean adGroupExternal) {
        isAdGroupExternal = adGroupExternal;
    }

    @Override
    public boolean isCopy() {
        return isCopy;
    }

    public void setCopy(boolean copy) {
        isCopy = copy;
    }

    @Override
    public boolean isFromApi() {
        return isFromApi;
    }

    public void setFromApi(boolean isFromApi) {
        this.isFromApi = isFromApi;
    }

    @Override
    public boolean isUniversalCampaignBanner(Banner banner) {
        CommonCampaign campaign = getCampaign(banner);
        return campaign != null
                ? AvailableCampaignSources.INSTANCE.isUC(campaign.getSource())
                : isUcPreValidation;
    }

    @Override
    public boolean isUcPreValidation() {
        return isUcPreValidation;
    }

    public void setUcPreValidation(boolean ucPreValidation) {
        isUcPreValidation = ucPreValidation;
    }
}
