package ru.yandex.direct.core.entity.banner.container;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupForBannerOperation;
import ru.yandex.direct.core.entity.adgroup.model.ContentPromotionAdgroupType;
import ru.yandex.direct.core.entity.banner.model.Banner;
import ru.yandex.direct.core.entity.banner.model.ImageSize;
import ru.yandex.direct.core.entity.banner.model.ImageType;
import ru.yandex.direct.core.entity.banner.service.moderation.ModerationMode;
import ru.yandex.direct.core.entity.banner.service.validation.BannerValidationInfo;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithContentLanguage;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithMobileContent;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithStrategy;
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign;
import ru.yandex.direct.core.entity.client.model.Client;
import ru.yandex.direct.core.entity.clientphone.ClientPhoneIdsByTypeContainer;
import ru.yandex.direct.core.entity.creative.model.Creative;
import ru.yandex.direct.core.entity.image.model.BannerImageFormat;
import ru.yandex.direct.core.entity.mobileapp.model.MobileAppTracker;
import ru.yandex.direct.core.entity.organization.model.Organization;
import ru.yandex.direct.core.entity.pricepackage.model.PricePackage;
import ru.yandex.direct.core.entity.sitelink.model.SitelinkSet;
import ru.yandex.direct.core.entity.turbolanding.model.TurboLanding;
import ru.yandex.direct.core.entity.vcard.model.Vcard;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.rbac.RbacRole;

/**
 * Здесь методы общие для операций добавления и обновления баннеров.
 * Полезно для использования в валидаторах, которые должны работать как на добавление так и на обновление.
 */
@ParametersAreNonnullByDefault
public interface BannersOperationContainer extends BannersModerationContainer {

    int getShard();

    Long getOperatorUid();

    RbacRole getOperatorRole();

    ClientId getClientId();

    Long getClientUid();

    Long getChiefUid();

    Long getClientRegionId();

    boolean isOperatorInternal();

    boolean isPartOfComplexOperation();

    boolean isValidateTrackingHrefMacros();

    Set<String> getClientEnabledFeatures();

    boolean isFromApi();

    ModerationMode getModerationMode();

    Client getClient();

    Collection<AdGroupForBannerOperation> getAdGroups();

    /**
     * Получить список уникальных групп.
     * В {@link #getAdGroups()} могут храниться дубли групп.
     */
    Collection<AdGroupForBannerOperation> getUniqueAdGroups();

    /**
     * Информация о группе.
     * Может вернуть null в следующем случае:
     * При добавлении баннера указанный id группы ссылается на группу, отсутствующую у клиента
     */
    @Nullable
    AdGroupForBannerOperation getAdGroup(Banner banner);

    /**
     * Индекс добавляемого баннера -> информация о нём из комплексной операции.
     */
    Map<Integer, BannerValidationInfo> getBannersValidationInfoMap();

    @Nullable
    BannerValidationInfo getBannersValidationInfo(Banner banner);

    /**
     * Информация о типе продвигаемого контента на его группе.
     * Может вернуть null в следующих случаях:
     * - при добавлении ContentPromotionBanner указанный id группы ссылается на группу другого типа
     * - при добавлении ContentPromotionBanner указанный id группы ссылается на группу,  отсутствующую у клиента
     */
    ContentPromotionAdgroupType getContentPromotionAdGroupType(Banner banner);

    Collection<CommonCampaign> getCampaigns();

    IdentityHashMap<Banner, Creative> getBannerToCreativeMap();

    boolean isCpmGeoProductAutoModeration();

    boolean isCpmGeoPinAutoModeration();

    Map<Long, Vcard> getVcardIdToData();

    /**
     * Id кампании -> информация о стратегии кампании
     * Если кампания не поддерживает стратегию, то в map'е не будет записи
     */
    Map<Long, CampaignWithStrategy> getCampaignIdToCampaignWithStrategyMap();

    Map<Long, CampaignWithContentLanguage> getCampaignIdToCampaignWithContentLanguageMap();

    Map<Long, CampaignWithMobileContent> getCampaignIdToCampaignWithMobileContentMap();

    Map<Long, PricePackage> getCampaignIdToPricePackageMap();
    Map<Long, Organization> getClientOrganizations();

    Map<Long, SitelinkSet> getSitelinkSets();

    @Nullable
    Map<Long, TurboLanding> getTurboLandings();

    ClientPhoneIdsByTypeContainer getAllowedPhoneIds();

    Set<Long> getAccessibleOrganizationsPermalinkId();

    // todo: удалить после включения новых лимитов заголовка
    // https://st.yandex-team.ru/DIRECT-141869
    boolean isUniversalCampaignBanner(Banner banner);

    boolean isUcPreValidation();

    @Nullable
    default PricePackage getPricePackage(Banner banner) {
        AdGroupForBannerOperation adGroup = getAdGroup(banner);
        if (adGroup == null) {
            return null;
        }
        return getCampaignIdToPricePackageMap().get(adGroup.getCampaignId());
    }

    @Nullable
    default CampaignWithStrategy getCampaignWithStrategy(Banner banner) {
        AdGroupForBannerOperation adGroup = getAdGroup(banner);
        if (adGroup == null) {
            return null;
        }
        return getCampaignIdToCampaignWithStrategyMap().get(adGroup.getCampaignId());
    }

    @Nullable
    default CampaignWithMobileContent getCampaignWithMobileContent(Banner banner) {
        AdGroupForBannerOperation adGroup = getAdGroup(banner);
        if (adGroup == null) {
            return null;
        }
        return getCampaignIdToCampaignWithMobileContentMap().get(adGroup.getCampaignId());
    }

    @Nullable
    default MobileAppTracker getMobileAppTracker(Banner banner) {
        CampaignWithMobileContent campaign = getCampaignWithMobileContent(banner);
        if (campaign == null) {
            return null;
        }
        List<MobileAppTracker> trackers = getMobileAppIdToTrackersMap().get(campaign.getMobileAppId());
        if (trackers == null || trackers.isEmpty()) {
            return null;
        }
        return trackers.get(0);
    }

    default boolean isFeatureEnabledForClient(FeatureName featureName) {
        return getClientEnabledFeatures().contains(featureName.getName());
    }

    Map<String, Pair<ImageType, ImageSize>> getExistingBigKingImageHashesWithType();

    Map<String, Pair<ImageType, ImageSize>> getExistingImageTypesWithSizes();

    Map<String, Pair<ImageType, ImageSize>> getExistingImageTypesWithSizesBeforeApply();

    Map<String, BannerImageFormat> getBannerImageFormats();

    Map<Long, List<MobileAppTracker>> getMobileAppIdToTrackersMap();
}
