package ru.yandex.direct.core.entity.banner.container;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jetbrains.annotations.NotNull;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupForBannerOperation;
import ru.yandex.direct.core.entity.banner.model.Banner;
import ru.yandex.direct.core.entity.banner.service.moderation.ModerationMode;
import ru.yandex.direct.core.entity.campaign.AvailableCampaignSources;
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign;
import ru.yandex.direct.dbschema.ppc.enums.BannersBannerType;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.rbac.RbacRole;

import static ru.yandex.direct.core.entity.banner.repository.BannerRepositoryConstants.BANNER_TYPE_TO_CLASS;

@ParametersAreNonnullByDefault
public class BannersUpdateOperationContainerImpl extends AbstractBannersOperationContainer
        implements BannersUpdateOperationContainer {

    private Map<Long, BannersBannerType> bannerTypeMap = new HashMap<>();

    private Map<Long, AdGroupForBannerOperation> bannerIdToAdgroupMap;
    private boolean isFromApi = false;
    private boolean isUcPreValidation = false;

    public BannersUpdateOperationContainerImpl(int shard,
                                               Long operatorUid,
                                               RbacRole operatorRole,
                                               ClientId clientId,
                                               Long clientUid,
                                               Long chiefUid,
                                               Long clientRegionId,
                                               Set<String> clientEnabledFeatures,
                                               ModerationMode moderationMode,
                                               boolean isOperatorInternal,
                                               boolean isPartOfComplexOperation,
                                               boolean validateTrackingHrefMacros) {
        super(shard, operatorUid, operatorRole, clientId, clientUid, chiefUid, clientRegionId, clientEnabledFeatures,
                moderationMode, isOperatorInternal, isPartOfComplexOperation, validateTrackingHrefMacros);
    }

    public void setBannerType(Long bannerId, BannersBannerType bannerType) {
        bannerTypeMap.put(bannerId, bannerType);
    }

    @Override
    public Class<? extends Banner> getRuntimeClass(@NotNull Long bannerId) {
        return BANNER_TYPE_TO_CLASS.get(bannerTypeMap.get(bannerId));
    }

    public void setBannerIdToAdGroupMap(Map<Long, AdGroupForBannerOperation> bannerIdToAdgroupMap) {
        this.bannerIdToAdgroupMap = bannerIdToAdgroupMap;
    }

    @Override
    public Map<Long, AdGroupForBannerOperation> getBannerIdToAdgroupMap() {
        return bannerIdToAdgroupMap;
    }

    @Override
    public boolean isFromApi() {
        return isFromApi;
    }

    public void setFromApi(boolean isFromApi) {
        this.isFromApi = isFromApi;
    }

    @Override
    public boolean isUniversalCampaignBanner(Banner banner) {
        CommonCampaign campaign = getCampaign(banner);
        return campaign != null && AvailableCampaignSources.INSTANCE.isUC(campaign.getSource());
    }

    @Override
    public boolean isUcPreValidation() {
        return isUcPreValidation;
    }

    public void setUcPreValidation(boolean isUcPreValidation) {
        this.isUcPreValidation = isUcPreValidation;
    }
}
