package ru.yandex.direct.core.entity.banner.container;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.adgroup.model.PageBlock;

import static com.google.common.base.Preconditions.checkState;

@ParametersAreNonnullByDefault
public class OutdoorModerateBannerPagesUpdateParams {

    private final List<PageBlock> adGroupPageBlocks;
    private final List<Long> adGroupGeo;
    private final Long bannerVersion;
    private final List<Long> bannerMinusGeo;

    private OutdoorModerateBannerPagesUpdateParams(List<PageBlock> adGroupPageBlocks, List<Long> adGroupGeo,
                                                   Long bannerVersion, List<Long> bannerMinusGeo) {
        this.adGroupPageBlocks = adGroupPageBlocks;
        this.adGroupGeo = adGroupGeo;
        this.bannerVersion = bannerVersion;
        this.bannerMinusGeo = bannerMinusGeo;
    }

    public List<PageBlock> getAdGroupPageBlocks() {
        return adGroupPageBlocks;
    }

    public List<Long> getAdGroupGeo() {
        return adGroupGeo;
    }

    public Long getBannerVersion() {
        return bannerVersion;
    }

    public List<Long> getBannerMinusGeo() {
        return bannerMinusGeo;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<PageBlock> adGroupPageBlocks;
        private List<Long> adGroupGeo;
        private Long bannerVersion;
        private List<Long> bannerMinusGeo;

        public Builder withAdGroupPageBlocks(List<PageBlock> adGroupPageBlocks) {
            this.adGroupPageBlocks = adGroupPageBlocks;
            return this;
        }

        public Builder withAdGroupGeo(List<Long> adGroupGeo) {
            this.adGroupGeo = adGroupGeo;
            return this;
        }

        public Builder withBannerVersion(Long bannerVersion) {
            this.bannerVersion = bannerVersion;
            return this;
        }

        public Builder withBannerMinusGeo(List<Long> bannerMinusGeo) {
            this.bannerMinusGeo = bannerMinusGeo;
            return this;
        }

        public OutdoorModerateBannerPagesUpdateParams build() {
            checkState(adGroupPageBlocks != null, "adgroup pages must be defined");
            checkState(adGroupGeo != null, "adgroup geo must be defined");
            checkState(bannerVersion != null, "banner version must be defined");
            checkState(bannerMinusGeo != null, "banner minus geo must be defined");
            return new OutdoorModerateBannerPagesUpdateParams(adGroupPageBlocks, adGroupGeo, bannerVersion,
                    bannerMinusGeo);
        }
    }
}
