package ru.yandex.direct.core.entity.banner.old;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.banner.model.old.Image;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerImage;

/**
 * Утилита для клонирования моделей, связанных с баннерами.
 * Написана, чтобы
 * <ul>
 * <li>этот скучный код не приходилось повторять;</li>
 * <li>при изменении атрибутного состава моделей падал соответствующий тест.</li>
 * </ul>
 * <p>
 * Почему не {@link org.apache.commons.beanutils.BeanUtils}? Чтобы не рефлекшн.
 */
@ParametersAreNonnullByDefault
@Deprecated
public class BannerBeanUtil {

    private BannerBeanUtil() {
        // no instantiation
    }

    public static OldBannerImage cloneBannerImage(OldBannerImage original) {
        return new OldBannerImage()
                .withId(original.getId())
                .withImageHash(original.getImageHash())
                .withName(original.getName())
                .withBannerId(original.getBannerId())
                .withBsBannerId(original.getBsBannerId())
                .withStatusModerate(original.getStatusModerate())
                .withStatusShow(original.getStatusShow())
                .withDateAdded(original.getDateAdded())
                .withImageType(original.getImageType());
    }

    public static Image cloneImage(Image original) {
        return new Image()
                .withId(original.getId())
                .withCampaignId(original.getCampaignId())
                .withAdGroupId(original.getAdGroupId())
                .withImageHash(original.getImageHash())
                .withBannerId(original.getBannerId())
                .withStatusModerate(original.getStatusModerate())
                .withImageText(original.getImageText())
                .withDisclaimerText(original.getDisclaimerText());
    }
}
