package ru.yandex.direct.core.entity.banner.repository;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import static ru.yandex.direct.utils.FunctionalUtils.filterList;

/**
 * Простейшая имплементация разбивает строки следующием образом:
 * - все старые строки, кроме тех, что в точности содержатся в новых нужно "удалить".
 * - все новые строки, кроме тех, что в точности содержатся в старых нужно "добавить или обновить".
 * Для сравнения использует equals.
 * <p>В силу своей примитивности в "добавить или обновить" на самом деле оказывается только то, что нужно
 * "добавить", а всё что можно было бы обновить - попадает в "удалить".
 */
@ParametersAreNonnullByDefault
public final class AddAndDeleteContainer<T> implements AddOrUpdateAndDeleteContainer<T> {

    private final Set<T> oldRows = new HashSet<>();
    private final Set<T> newRows = new HashSet<>();

    @Override
    public Collection<T> getRowsToDelete() {
        return filterList(oldRows, oldRow -> !newRows.contains(oldRow));
    }

    @Override
    public Collection<T> getRowsToAddOrUpdate() {
        return filterList(newRows, newRow -> !oldRows.contains(newRow));
    }

    public void addOld(Collection<T> oldRows) {
        this.oldRows.addAll(oldRows);
    }

    public void addNew(Collection<T> newRows) {
        this.newRows.addAll(newRows);
    }

}
