package ru.yandex.direct.core.entity.banner.repository;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Table;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.banner.container.BannerRepositoryContainer;
import ru.yandex.direct.core.entity.banner.model.Banner;
import ru.yandex.direct.core.entity.banner.model.BannerWithAdGroupId;
import ru.yandex.direct.core.entity.banner.repository.type.BannerRepositoryTypeSupportFacade;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.multitype.repository.TypeModifyRepository;
import ru.yandex.direct.multitype.repository.filter.ConditionFilter;

import static ru.yandex.direct.core.entity.banner.repository.filter.BannerFilterFactory.bannerIdFilter;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Repository
@ParametersAreNonnullByDefault
public class BannerModifyRepository extends TypeModifyRepository<Banner, BannerWithAdGroupId,
        BannerRepositoryContainer, BannerRepositoryContainer> {

    private final ShardHelper shardHelper;

    @Autowired
    public BannerModifyRepository(DslContextProvider ppcDslContextProvider,
                                     BannerRepositoryTypeSupportFacade typeSupportFacade,
                                     BannerTypedRepository typedRepository,
                                     ShardHelper shardHelper) {
        super(ppcDslContextProvider, typeSupportFacade, typedRepository);
        this.shardHelper = shardHelper;
    }

    @Override
    protected void generateIds(BannerRepositoryContainer addContainer, List<? extends BannerWithAdGroupId> models) {
        Iterator<Long> bannerIds = shardHelper.generateBannerIds(mapList(models, BannerWithAdGroupId::getAdGroupId))
                .iterator();
        models.forEach(banner -> banner.withId(bannerIds.next()));
    }

    @Override
    protected Table<?> getLockTable() {
        return BANNERS;
    }

    @Override
    protected ConditionFilter getIdFilter(Collection<Long> modelIds) {
        return bannerIdFilter(modelIds);
    }
}
