package ru.yandex.direct.core.entity.banner.repository;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.banner.type.additionalhrefs.BannerAdditionalHrefsRepository;
import ru.yandex.direct.core.entity.banner.type.bigkingimage.BannerBigKingImageRepository;
import ru.yandex.direct.core.entity.banner.type.button.BannerButtonsRepository;
import ru.yandex.direct.core.entity.banner.type.creative.BannerCreativeRepository;
import ru.yandex.direct.core.entity.banner.type.displayhref.BannerDisplayHrefRepository;
import ru.yandex.direct.core.entity.banner.type.href.BannerDomainRepository;
import ru.yandex.direct.core.entity.banner.type.image.BannerImageRepository;
import ru.yandex.direct.core.entity.banner.type.logos.BannerLogosRepository;
import ru.yandex.direct.core.entity.banner.type.measurers.BannerMeasurersRepository;
import ru.yandex.direct.core.entity.banner.type.moderation.BannerStatusRepository;
import ru.yandex.direct.core.entity.banner.type.name.BannerNamesRepository;
import ru.yandex.direct.core.entity.banner.type.performance.BannerPerformanceMainRepository;
import ru.yandex.direct.core.entity.banner.type.pixels.BannerPixelsRepository;
import ru.yandex.direct.core.entity.banner.type.price.BannerPriceRepository;
import ru.yandex.direct.core.entity.banner.type.tns.BannerTnsRepository;
import ru.yandex.direct.core.entity.banner.type.turboapp.BannerTurboAppsRepository;

@Repository
@ParametersAreNonnullByDefault
public class BannerRepository {

    public final BannerAdditionalHrefsRepository additionalHrefs;
    public final BannerButtonsRepository buttons;
    public final BannerCommonRepository common;
    public final BannerCreativeRepository creative;
    public final BannerDisplayHrefRepository displayHrefRepository;
    public final BannerDomainRepository domain;
    public final BannerImageRepository image;
    public final BannerLogosRepository logos;
    public final BannerBigKingImageRepository bigKingImage;
    public final BannerMeasurersRepository measures;
    public final BannerModerationRepository moderation;
    public final BannerModifyRepository modification;
    public final BannerNamesRepository names;
    public final BannerPixelsRepository pixels;
    public final BannerPriceRepository price;
    public final BannerRelationsRepository relations;
    public final BannerStatusRepository status;
    public final BannerTnsRepository tns;
    public final BannerTurboAppsRepository turboApps;
    public final BannerTypedRepository type;
    public final BannerPerformanceMainRepository performanceMain;

    @Autowired
    public BannerRepository(BannerAdditionalHrefsRepository additionalHrefs,
                            BannerButtonsRepository buttons,
                            BannerCommonRepository common,
                            BannerCreativeRepository creative,
                            BannerDisplayHrefRepository displayHrefRepository, BannerDomainRepository domain,
                            BannerImageRepository image,
                            BannerLogosRepository logos,
                            BannerBigKingImageRepository bigKingImage,
                            BannerMeasurersRepository measures,
                            BannerModerationRepository moderation,
                            BannerModifyRepository modification,
                            BannerNamesRepository names,
                            BannerPixelsRepository pixels,
                            BannerPriceRepository price,
                            BannerRelationsRepository relations,
                            BannerStatusRepository status,
                            BannerTnsRepository tns,
                            BannerTurboAppsRepository turboApps,
                            BannerTypedRepository type,
                            BannerPerformanceMainRepository performanceMain
    ) {
        this.additionalHrefs = additionalHrefs;
        this.buttons = buttons;
        this.common = common;
        this.creative = creative;
        this.displayHrefRepository = displayHrefRepository;
        this.domain = domain;
        this.image = image;
        this.logos = logos;
        this.bigKingImage = bigKingImage;
        this.measures = measures;
        this.moderation = moderation;
        this.modification = modification;
        this.names = names;
        this.pixels = pixels;
        this.price = price;
        this.relations = relations;
        this.status = status;
        this.tns = tns;
        this.turboApps = turboApps;
        this.type = type;
        this.performanceMain = performanceMain;
    }
}
