package ru.yandex.direct.core.entity.banner.repository;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.function.Supplier;

import com.google.common.collect.ImmutableBiMap;
import one.util.streamex.EntryStream;

import ru.yandex.direct.core.entity.banner.model.Banner;
import ru.yandex.direct.core.entity.banner.model.ContentPromotionBanner;
import ru.yandex.direct.core.entity.banner.model.CpcVideoBanner;
import ru.yandex.direct.core.entity.banner.model.CpmAudioBanner;
import ru.yandex.direct.core.entity.banner.model.CpmBanner;
import ru.yandex.direct.core.entity.banner.model.CpmGeoPinBanner;
import ru.yandex.direct.core.entity.banner.model.CpmIndoorBanner;
import ru.yandex.direct.core.entity.banner.model.CpmOutdoorBanner;
import ru.yandex.direct.core.entity.banner.model.DynamicBanner;
import ru.yandex.direct.core.entity.banner.model.ImageBanner;
import ru.yandex.direct.core.entity.banner.model.InternalBanner;
import ru.yandex.direct.core.entity.banner.model.McBanner;
import ru.yandex.direct.core.entity.banner.model.MobileAppBanner;
import ru.yandex.direct.core.entity.banner.model.PerformanceBanner;
import ru.yandex.direct.core.entity.banner.model.PerformanceBannerMain;
import ru.yandex.direct.core.entity.banner.model.TextBanner;
import ru.yandex.direct.dbschema.ppc.enums.BannersBannerType;

public class BannerRepositoryConstants {

    private BannerRepositoryConstants() {
    }

    public static final ImmutableBiMap<Class<? extends Banner>, BannersBannerType> BANNER_CLASS_TO_TYPE =
            new ImmutableBiMap.Builder<Class<? extends Banner>, BannersBannerType>()
                    .put(ContentPromotionBanner.class, BannersBannerType.content_promotion)
                    .put(TextBanner.class, BannersBannerType.text)
                    .put(CpcVideoBanner.class, BannersBannerType.cpc_video)
                    .put(CpmAudioBanner.class, BannersBannerType.cpm_audio)
                    .put(CpmIndoorBanner.class, BannersBannerType.cpm_indoor)
                    .put(CpmOutdoorBanner.class, BannersBannerType.cpm_outdoor)
                    .put(CpmBanner.class, BannersBannerType.cpm_banner)
                    .put(CpmGeoPinBanner.class, BannersBannerType.cpm_geo_pin)
                    .put(MobileAppBanner.class, BannersBannerType.mobile_content)
                    .put(ImageBanner.class, BannersBannerType.image_ad)
                    .put(InternalBanner.class, BannersBannerType.internal)
                    .put(DynamicBanner.class, BannersBannerType.dynamic)
                    .put(PerformanceBanner.class, BannersBannerType.performance)
                    .put(McBanner.class, BannersBannerType.mcbanner)
                    .put(PerformanceBannerMain.class, BannersBannerType.performance_main)
                    .build();

    public static final ImmutableBiMap<BannersBannerType, Class<? extends Banner>> BANNER_TYPE_TO_CLASS =
            BANNER_CLASS_TO_TYPE.inverse();

    public static final Map<BannersBannerType, Supplier<Banner>> TYPE_TO_BANNER_CLASS_SUPPLIER =
            EntryStream.of(BANNER_TYPE_TO_CLASS)
                    .mapValues(x -> (Supplier<Banner>) () -> {
                        try {
                            return x.getDeclaredConstructor().newInstance();
                        } catch (InstantiationException | IllegalAccessException | InvocationTargetException
                                | NoSuchMethodException e) {
                            throw new RuntimeException(e);
                        }
                    })
                    .toImmutableMap();

    /**
     * Бинарные опции (флаги) баннера и соответствующие им названия в таблице.
     * Поле: {@code ppc.banners.opts}.
     */
    public static class Opts {

        /**
         * Нужно ли выводить город, при показе баннера на выдаче (геотаргетинг достаточно узкий).
         */
        public static final String GEO_FLAG = "geoflag";

        private Opts() {
        }

    }

}
