package ru.yandex.direct.core.entity.banner.repository.mapper;

import java.util.HashSet;
import java.util.Set;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import org.apache.commons.lang3.StringUtils;

import static org.apache.commons.lang3.StringUtils.isEmpty;
import static ru.yandex.direct.core.entity.banner.repository.BannerRepositoryConstants.Opts.GEO_FLAG;

public class TextBannerMappings {

    private static final String OPTS_SEPARATOR = ",";
    private static final Splitter OPTS_SPLITTER = Splitter.on(OPTS_SEPARATOR).omitEmptyStrings();

    /**
     * Обновить в наборе параметров баннера геофлаг
     */
    public static String updateGeoFlagInOpts(String opts, Boolean geoFlag) {
        Set<String> flags = new HashSet<>();
        if (!isEmpty(opts)) {
            Iterables.addAll(flags, OPTS_SPLITTER.split(opts));
        }
        if (geoFlag) {
            flags.add(GEO_FLAG);
        } else {
            flags.remove(GEO_FLAG);
        }
        return StringUtils.join(flags, OPTS_SEPARATOR);
    }
}
