package ru.yandex.direct.core.entity.banner.repository.old;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.util.mysql.MySQLDSL;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.banner.model.old.OldBannerButton;
import ru.yandex.direct.dbschema.ppc.tables.records.BannerButtonsRecord;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;

import static ru.yandex.direct.core.entity.banner.repository.old.mapper.BannerButtonsMapperProvider.getBannerButtonsMapper;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_BUTTONS;

@Repository
@ParametersAreNonnullByDefault
@Deprecated
public class OldBannerButtonsRepository {

    private final DslContextProvider dslContextProvider;
    private final JooqMapperWithSupplier<OldBannerButton> mapper = getBannerButtonsMapper();

    public OldBannerButtonsRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    /**
     * Добавление или изменение кнопки у баннеров
     *
     * @param context       контекст
     * @param bannerButtons список кнопок
     */
    public void update(DSLContext context, Collection<OldBannerButton> bannerButtons) {
        InsertHelper<BannerButtonsRecord> insertHelper = new InsertHelper<>(context, BANNER_BUTTONS)
                .addAll(mapper, bannerButtons);

        if (insertHelper.hasAddedRecords()) {
            insertHelper.onDuplicateKeyUpdate()
                    .set(BANNER_BUTTONS.KEY, MySQLDSL.values(BANNER_BUTTONS.KEY))
                    .set(BANNER_BUTTONS.CAPTION, MySQLDSL.values(BANNER_BUTTONS.CAPTION))
                    .set(BANNER_BUTTONS.HREF, MySQLDSL.values(BANNER_BUTTONS.HREF))
                    .set(BANNER_BUTTONS.STATUS_MODERATE, MySQLDSL.values(BANNER_BUTTONS.STATUS_MODERATE));
        }

        insertHelper.executeIfRecordsAdded();
    }

    /**
     * Удаление кнопок
     *
     * @param context   контекст
     * @param bannerIds идентификаторы баннеров
     */
    public void delete(DSLContext context, Collection<Long> bannerIds) {
        context
                .deleteFrom(BANNER_BUTTONS)
                .where(BANNER_BUTTONS.BID.in(bannerIds))
                .execute();
    }
}
