package ru.yandex.direct.core.entity.banner.repository.old;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Repository;

import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_MODERATION_VERSIONS;
import static ru.yandex.direct.dbschema.ppc.tables.BannersContentPromotion.BANNERS_CONTENT_PROMOTION;

/**
 * @deprecated use BannerContentPromotionRepository
 * <p>
 * Репозиторий для работы с таблицей ppc.content_promotion
 */
@Repository
@ParametersAreNonnullByDefault
@Deprecated
public class OldBannerContentPromotionRepository {
    protected final DslContextProvider dslContextProvider;
    protected final ShardHelper shardHelper;


    public OldBannerContentPromotionRepository(DslContextProvider dslContextProvider, ShardHelper shardHelper) {
        this.dslContextProvider = dslContextProvider;
        this.shardHelper = shardHelper;
    }

    /**
     * Получает наборы id-шников баннеров, которые были в модерации, по id контента, к ним привязанного.
     * Нужно, например, для обновления баннеров при обновлении контента.
     *
     * @param shard      обрабатываемый шард
     * @param contentIds набор id контента
     * @return мапа (id контента) - (список id баннеров, которые были в модерации и к которому оно привязано)
     */
    public Map<Long, List<Long>> getBeenInModerationBannerIdsByContentId(int shard, List<Long> contentIds) {
        return dslContextProvider.ppc(shard)
                .select(BANNERS_CONTENT_PROMOTION.CONTENT_PROMOTION_ID,
                        BANNERS_CONTENT_PROMOTION.BID)
                .from(BANNERS_CONTENT_PROMOTION)
                // Дополнительная защита в случае, если нет записи в banners
                .join(BANNERS).on(BANNERS.BID.eq(BANNERS_CONTENT_PROMOTION.BID))
                .join(BANNER_MODERATION_VERSIONS).on(BANNER_MODERATION_VERSIONS.BID.eq(BANNERS.BID))
                .where(BANNERS_CONTENT_PROMOTION.CONTENT_PROMOTION_ID.in(contentIds))
                .fetchGroups(BANNERS_CONTENT_PROMOTION.CONTENT_PROMOTION_ID,
                        BANNERS_CONTENT_PROMOTION.BID);
    }
}
