package ru.yandex.direct.core.entity.banner.repository.old;

import java.util.Collection;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.banner.model.old.OldBannerCreative;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;

import static ru.yandex.direct.core.entity.banner.repository.old.mapper.BannerCreativeMapperProvider.getBannerCreativeMapper;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS_PERFORMANCE;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Repository
@ParametersAreNonnullByDefault
@Deprecated
public class OldBannerCreativeRepository {

    private static final JooqMapperWithSupplier<OldBannerCreative> bannerCreativeMapper =
            getBannerCreativeMapper();
    private final DslContextProvider dslContextProvider;
    private final ShardHelper shardHelper;

    @Autowired
    public OldBannerCreativeRepository(DslContextProvider dslContextProvider, ShardHelper shardHelper) {
        this.dslContextProvider = dslContextProvider;
        this.shardHelper = shardHelper;

    }

    /**
     * Сохраняет список баннер-креативов (атрибут баннера, указывающий на креатив)
     * В переданных объектах креатив-баннеров так же выставляются сгенерированные id
     *
     * @param shard     шард
     * @param banners список сохраняемых баннер-креативов
     * @return список id сохраненных баннер-креативов
     */
    public List<Long> addBannerCreatives(int shard, List<OldBannerCreative> banners) {
        fillBannerCreativeIds(banners);
        addBannerCreativeToBannerPerformanceTable(shard, banners);
        return mapList(banners, OldBannerCreative::getId);
    }

    /**
     * Генерирует новые bannerCreativeId и выставляет эти id каждому баннер-креативу в переданном списке
     *
     * @param bannerCreatives список баннер-креативов, которым нужно сгенерировать новые id (bannerCreativeId)
     */
    private void fillBannerCreativeIds(Collection<OldBannerCreative> bannerCreatives) {
        List<Long> bannerCreativeIds = shardHelper.generateBannerCreativeIds(bannerCreatives.size());
        StreamEx.of(bannerCreatives).zipWith(bannerCreativeIds.stream())
                .forKeyValue(OldBannerCreative::setId);
    }

    /**
     * Добавление записи о связи баннера с креативом в таблицу ppc.banners_performance
     */
    private void addBannerCreativeToBannerPerformanceTable(int shard, List<OldBannerCreative> banners) {
        new InsertHelper<>(dslContextProvider.ppc(shard), BANNERS_PERFORMANCE)
                .addAll(bannerCreativeMapper, banners)
                .executeIfRecordsAdded();
    }

}
