package ru.yandex.direct.core.entity.banner.repository.old;

import java.util.Collection;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.util.mysql.MySQLDSL;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.banner.model.old.OldBannerWithDisplayHref;
import ru.yandex.direct.core.entity.banner.repository.old.container.AddOrUpdateAndDeleteContainer;
import ru.yandex.direct.dbschema.ppc.Tables;
import ru.yandex.direct.dbschema.ppc.tables.records.BannerDisplayHrefsRecord;
import ru.yandex.direct.jooqmapper.JooqModelToDbMapper;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.repository.old.mapper.TextBannerMapperProvider.getTextBannerMapper;
import static ru.yandex.direct.dbschema.ppc.tables.BannerDisplayHrefs.BANNER_DISPLAY_HREFS;

/**
 * Класс для разгрузки {@link OldBannerRepository} –
 * делегат, инкапсулирующий обработку {@code Banner.HREF} и {@code Banner.DISPLAY_HREF}.
 */
@Repository
@ParametersAreNonnullByDefault
@Deprecated
public class OldBannerHrefRepository {

    /**
     * Удаление "зеленого урла", отображаемого при показе баннера.
     *
     * @param context   контекст
     * @param bannerIds список id баннеров
     */
    public void deleteBannerDisplayHrefs(DSLContext context, Collection<Long> bannerIds) {
        if (bannerIds.isEmpty()) {
            return;
        }
        context
                .deleteFrom(Tables.BANNER_DISPLAY_HREFS)
                .where(Tables.BANNER_DISPLAY_HREFS.BID.in(bannerIds))
                .execute();
    }

    /**
     * Сохранить "зелёный URL", т.е. тот, что отображается при показе баннера.
     *
     * @param context DSL контекст jooq
     * @param banners список текстовых баннеров
     */
    public <B extends OldBannerWithDisplayHref> void addOrUpdateBannerDisplayHrefs(DSLContext context, List<B> banners) {
        @SuppressWarnings("unchecked")
        JooqModelToDbMapper<B> mapper = (JooqModelToDbMapper) getTextBannerMapper();
        InsertHelper<BannerDisplayHrefsRecord> insertHelper =
                new InsertHelper<>(context, BANNER_DISPLAY_HREFS)
                        .addAll(mapper, banners);
        if (insertHelper.hasAddedRecords()) {
            insertHelper.onDuplicateKeyUpdate()
                    .set(BANNER_DISPLAY_HREFS.DISPLAY_HREF, MySQLDSL.values(BANNER_DISPLAY_HREFS.DISPLAY_HREF))
                    .set(BANNER_DISPLAY_HREFS.STATUS_MODERATE, MySQLDSL.values(BANNER_DISPLAY_HREFS.STATUS_MODERATE));
        }
        insertHelper.executeIfRecordsAdded();
    }

    /**
     * Разделить баннеры на те, у которых требуется удалить {@link OldBannerWithDisplayHref#getDisplayHref},
     * и те, у которых нужно добавить или обновить.
     *
     * @param appliedChangesCollection коллекция изменений, применяемых к баннерам.
     * @return DTO, содержащий два множества баннеров, {@link AddOrUpdateAndDeleteContainer}.
     */
    public <B extends OldBannerWithDisplayHref> AddOrUpdateAndDeleteContainer<B> prepareDisplayHrefsUpdateContainer(
            Collection<AppliedChanges<B>> appliedChangesCollection) {
        final AddOrUpdateAndDeleteContainer<B> updateContainer = new AddOrUpdateAndDeleteContainer<>();

        // banners to delete display hrefs
        appliedChangesCollection.stream()
                .filter(this::isDisplayHrefDeleted)
                .map(AppliedChanges::getModel)
                .forEach(updateContainer::markForDeletion);

        // banners to add or update display hrefs
        appliedChangesCollection.stream()
                .filter(this::isDisplayHrefAddedOrUpdated)
                .map(AppliedChanges::getModel)
                .forEach(updateContainer::markForAddOrUpdate);

        return updateContainer;
    }

    private <B extends OldBannerWithDisplayHref> boolean isDisplayHrefDeleted(AppliedChanges<B> appliedChanges) {
        return appliedChanges.changed(B.DISPLAY_HREF)
                && appliedChanges.getNewValue(B.DISPLAY_HREF) == null;
    }

    private <B extends OldBannerWithDisplayHref> boolean isDisplayHrefAddedOrUpdated(AppliedChanges<B> appliedChanges) {
        boolean isDisplayHrefChanged = appliedChanges.changed(B.DISPLAY_HREF)
                || appliedChanges.changed(B.DISPLAY_HREF_STATUS_MODERATE);
        return isDisplayHrefChanged && appliedChanges.getNewValue(B.DISPLAY_HREF) != null;
    }

}
