package ru.yandex.direct.core.entity.banner.repository.old;

import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.util.mysql.MySQLDSL;

import ru.yandex.direct.core.entity.banner.model.old.OldBannerWithLogo;
import ru.yandex.direct.core.entity.banner.model.old.StatusBannerLogoModerate;
import ru.yandex.direct.dbschema.ppc.tables.records.BannerLogosRecord;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_LOGOS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@ParametersAreNonnullByDefault
@Deprecated
public class OldBannerLogosRepository<T extends OldBannerWithLogo> {

    private final DslContextProvider dslContextProvider;
    private final JooqMapperWithSupplier<T> bannerLogosMapper;
    private final Supplier<T> modelSupplier;

    public OldBannerLogosRepository(DslContextProvider dslContextProvider, Supplier<T> modelSupplier) {
        this.dslContextProvider = dslContextProvider;
        this.modelSupplier = modelSupplier;
        bannerLogosMapper = createBannerLogoMapper();
    }

    /**
     * Получение списка логотипов
     *
     * @param shard     шард для запроса
     * @param bannerIds список id баннеров
     * @return мапа bannerId -> хеш логотипа
     */
    public Map<Long, String> get(int shard, Collection<Long> bannerIds) {
        return dslContextProvider.ppc(shard)
                .select(BANNER_LOGOS.BID, BANNER_LOGOS.IMAGE_HASH)
                .from(BANNER_LOGOS)
                .where(BANNER_LOGOS.BID.in(bannerIds))
                .fetchMap(BANNER_LOGOS.BID, BANNER_LOGOS.IMAGE_HASH);
    }

    /**
     * Привязка логотипов к баннерам
     *
     * @param context контекст
     * @param banners список баннеров
     */
    public void update(DSLContext context, Collection<T> banners) {
        InsertHelper<BannerLogosRecord> insertHelper = new InsertHelper<>(context, BANNER_LOGOS)
                .addAll(bannerLogosMapper, banners);

        if (insertHelper.hasAddedRecords()) {
            insertHelper.onDuplicateKeyUpdate()
                    .set(BANNER_LOGOS.IMAGE_HASH, MySQLDSL.values(BANNER_LOGOS.IMAGE_HASH))
                    .set(BANNER_LOGOS.STATUS_MODERATE, MySQLDSL.values(BANNER_LOGOS.STATUS_MODERATE));
        }

        insertHelper.executeIfRecordsAdded();
    }

    /**
     * Удаление привязки баннера к логотипам
     *
     * @param context   контекст
     * @param bannerIds идентификаторы баннеров
     */
    public void delete(DSLContext context, Collection<Long> bannerIds) {
        context
                .deleteFrom(BANNER_LOGOS)
                .where(BANNER_LOGOS.BID.in(bannerIds))
                .execute();
    }

    private JooqMapperWithSupplier<T> createBannerLogoMapper() {
        return JooqMapperWithSupplierBuilder.builder(modelSupplier)
                .map(property(OldBannerWithLogo.ID, BANNER_LOGOS.BID))
                .map(property(OldBannerWithLogo.LOGO_IMAGE_HASH, BANNER_LOGOS.IMAGE_HASH))
                .map(convertibleProperty(OldBannerWithLogo.LOGO_STATUS_MODERATE, BANNER_LOGOS.STATUS_MODERATE,
                        StatusBannerLogoModerate::fromSource, StatusBannerLogoModerate::toSource))
                .build();
    }
}
