package ru.yandex.direct.core.entity.banner.repository.old;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.jooq.DSLContext;
import org.jooq.util.mysql.MySQLDSL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.banner.model.old.OldBannerMeasurer;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;

import static java.util.Collections.emptyMap;
import static java.util.function.Function.identity;
import static java.util.stream.Collectors.toList;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.BannerMeasurerMapperProvider.getBannerMeasurerMapper;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_MEASURERS;

@Repository
@ParametersAreNonnullByDefault
@Deprecated
public class OldBannerMeasurersRepository {

    private final JooqMapperWithSupplier<OldBannerMeasurer> bannerMeasurerMapper;
    private final DslContextProvider dslContextProvider;

    @Autowired
    public OldBannerMeasurersRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
        bannerMeasurerMapper = getBannerMeasurerMapper();
    }

    public void addBannerMeasurers(int shard, List<OldBannerMeasurer> bannerMeasurers) {
        addBannerMeasurers(dslContextProvider.ppc(shard), bannerMeasurers);
    }

    public void addBannerMeasurers(DSLContext context, List<OldBannerMeasurer> bannerMeasurers) {
        if (bannerMeasurers.isEmpty()) {
            return;
        }

        var insertHelper = new InsertHelper<>(context, BANNER_MEASURERS).addAll(bannerMeasurerMapper, bannerMeasurers);
        if (insertHelper.hasAddedRecords()) {
            insertHelper.onDuplicateKeyUpdate()
                    .set(BANNER_MEASURERS.MEASURER_SYSTEM, MySQLDSL.values(BANNER_MEASURERS.MEASURER_SYSTEM))
                    .set(BANNER_MEASURERS.PARAMS, MySQLDSL.values(BANNER_MEASURERS.PARAMS))
                    .set(BANNER_MEASURERS.HAS_INTEGRATION, MySQLDSL.values(BANNER_MEASURERS.HAS_INTEGRATION));
        }

        insertHelper.executeIfRecordsAdded();
    }

    // перенесено в BannerMeasurersRepository
    public void deleteBannersMeasurers(DSLContext context, List<Long> bannersIds) {
        if (bannersIds.isEmpty()) {
            return;
        }

        context.deleteFrom(BANNER_MEASURERS)
                .where(BANNER_MEASURERS.BID.in(bannersIds))
                .execute();
    }

    // перенесено в BannerMeasurersRepository
    @Deprecated
    public Map<Long, List<OldBannerMeasurer>> getMeasurersByBannerIds(int shard, @Nullable Collection<Long> bannerIds) {
        if (bannerIds == null || bannerIds.isEmpty()) {
            return emptyMap();
        }

        var bannerMeasurers = dslContextProvider.ppc(shard)
                .select(BANNER_MEASURERS.BID,
                        BANNER_MEASURERS.MEASURER_SYSTEM,
                        BANNER_MEASURERS.PARAMS,
                        BANNER_MEASURERS.HAS_INTEGRATION)
                .from(BANNER_MEASURERS)
                .where(BANNER_MEASURERS.BID.in(bannerIds))
                .fetch()
                .map(bannerMeasurerMapper::fromDb);

        return StreamEx.of(bannerMeasurers)
                .mapToEntry(OldBannerMeasurer::getBannerId, identity())
                .collapseKeys(toList())
                .toMap();
    }
}
