package ru.yandex.direct.core.entity.banner.repository.old;

import java.util.Collection;
import java.util.Map;

import org.jooq.DSLContext;
import org.jooq.util.mysql.MySQLDSL;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.banner.model.old.OldBannerPrice;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerWithPrice;
import ru.yandex.direct.core.entity.banner.repository.old.mapper.BannerPriceMapperProvider;
import ru.yandex.direct.dbschema.ppc.tables.records.BannerPricesRecord;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_PRICES;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

/**
 * Репозиторий для цен на товар на баннере из таблички ppc.banner_prices
 */
@Repository
@Deprecated
public class OldBannerPricesRepository {
    private final DslContextProvider dslContextProvider;

    private final JooqMapperWithSupplier<OldBannerPrice> bannerPriceMapper;

    public OldBannerPricesRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
        this.bannerPriceMapper = BannerPriceMapperProvider.getBannerPriceMapper();
    }

    /**
     * Добавляет цены на товар на баннерах. В случае если цена с таким bannerId уже имеется - обновляет ее.
     *
     * @param banners список баннеров
     * @param shard   шард
     */
    public void addOrUpdateBannerPrices(int shard, Collection<? extends OldBannerWithPrice> banners) {
        DSLContext context = dslContextProvider.ppc(shard);
        addOrUpdateBannerPrices(banners, context);
    }

    /**
     * Добавляет цены на товар на баннерах. В случае если цена с таким bannerId уже имеется - обновляет ее.
     * Метод используется для транзакций с общим контекстом
     *
     * @param banners Список баннеров
     * @param context Контекст для использования в транзакции
     */
    public void addOrUpdateBannerPrices(Collection<? extends OldBannerWithPrice> banners, DSLContext context) {
        InsertHelper<BannerPricesRecord> helper = new InsertHelper<>(context, BANNER_PRICES);

        banners.stream().filter(banner -> banner.getBannerPrice() != null).forEach(banner -> {
            helper.add(bannerPriceMapper, banner.getBannerPrice());
            helper.set(BANNER_PRICES.BID, banner.getId());
            helper.newRecord();
        });

        if (helper.hasAddedRecords()) {
            helper.onDuplicateKeyUpdate()
                    .set(BANNER_PRICES.CURRENCY, MySQLDSL.values(BANNER_PRICES.CURRENCY))
                    .set(BANNER_PRICES.PRICE, MySQLDSL.values(BANNER_PRICES.PRICE))
                    .set(BANNER_PRICES.PRICE_OLD, MySQLDSL.values(BANNER_PRICES.PRICE_OLD))
                    .set(BANNER_PRICES.PREFIX, MySQLDSL.values(BANNER_PRICES.PREFIX));
            helper.execute();
        }
    }

    /**
     * Возвращает цены на баннеры по списку ID баннеров
     */
    public Map<Long, OldBannerPrice> getBannerPricesByBannerIds(int shard, Collection<Long> bannerIds) {
        return dslContextProvider.ppc(shard)
                .select(BANNER_PRICES.BID, BANNER_PRICES.CURRENCY, BANNER_PRICES.PRICE, BANNER_PRICES.PRICE_OLD,
                        BANNER_PRICES.PREFIX)
                .from(BANNER_PRICES)
                .where(BANNER_PRICES.BID.in(bannerIds))
                .fetchMap(BANNER_PRICES.BID, bannerPriceMapper::fromDb);
    }

    /**
     * Удаляет цены на баннеры по списку баннеров
     */
    public void deleteBannerPrices(Collection<? extends OldBannerWithPrice> banners, DSLContext context) {
        context
                .deleteFrom(BANNER_PRICES)
                .where(BANNER_PRICES.BID.in(
                        mapList(banners, OldBannerWithPrice::getId)))
                .execute();
    }

}
