package ru.yandex.direct.core.entity.banner.repository.old;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.jooq.DSLContext;
import org.jooq.util.mysql.MySQLDSL;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.banner.model.BannerTurboAppType;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerTurboApp;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerWithPrice;
import ru.yandex.direct.dbschema.ppc.tables.records.BannerTurboAppsRecord;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;
import ru.yandex.direct.jooqmapperhelper.JooqUpdateBuilder;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.service.old.BannerUtils.countBannerTurboAppType;
import static ru.yandex.direct.dbschema.ppc.tables.BannerTurboApps.BANNER_TURBO_APPS;
import static ru.yandex.direct.dbschema.ppc.tables.Banners.BANNERS;
import static ru.yandex.direct.dbschema.ppc.tables.TurboAppsInfo.TURBO_APPS_INFO;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@Repository
@Deprecated
public class OldBannerTurboAppsRepository {

    private final DslContextProvider dslContextProvider;
    private final ShardHelper shardHelper;
    private static final JooqMapperWithSupplier<OldBannerTurboApp> MAPPER = createMapper();

    public OldBannerTurboAppsRepository(DslContextProvider dslContextProvider, ShardHelper shardHelper) {
        this.dslContextProvider = dslContextProvider;
        this.shardHelper = shardHelper;
    }

    private static JooqMapperWithSupplier<OldBannerTurboApp> createMapper() {
        return JooqMapperWithSupplierBuilder.builder(OldBannerTurboApp::new)
                .map(property(OldBannerTurboApp.BANNER_ID, BANNER_TURBO_APPS.BID))
                .map(property(OldBannerTurboApp.TURBO_APP_INFO_ID, BANNER_TURBO_APPS.TURBO_APP_INFO_ID))
                .map(convertibleProperty(OldBannerTurboApp.BANNER_TURBO_APP_TYPE, BANNER_TURBO_APPS.BANNER_TURBO_APP_TYPE,
                        BannerTurboAppType::fromSource, BannerTurboAppType::toSource))
                .map(property(OldBannerTurboApp.CONTENT, BANNER_TURBO_APPS.CONTENT))
                .build();
    }

    public List<OldBannerTurboApp> getAllTurboApps() {
        List<OldBannerTurboApp> result = new ArrayList<>();
        shardHelper.forEachShard(shard -> result.addAll(getAllTurboApps(shard)));
        return result;
    }

    public List<OldBannerTurboApp> getAllTurboApps(int shard) {
        return dslContextProvider.ppc(shard)
                .select(MAPPER.getFieldsToRead())
                .from(BANNER_TURBO_APPS)
                .join(TURBO_APPS_INFO).on(BANNER_TURBO_APPS.TURBO_APP_INFO_ID.eq(TURBO_APPS_INFO.TURBO_APP_INFO_ID))
                .fetch(MAPPER::fromDb);
    }

    public List<OldBannerTurboApp> getTurboAppByBannerIds(int shard, Collection<Long> bannerIds) {
        return dslContextProvider.ppc(shard)
                .select(MAPPER.getFieldsToRead())
                .from(BANNER_TURBO_APPS)
                .join(TURBO_APPS_INFO).on(BANNER_TURBO_APPS.TURBO_APP_INFO_ID.eq(TURBO_APPS_INFO.TURBO_APP_INFO_ID))
                .where(BANNER_TURBO_APPS.BID.in(bannerIds))
                .fetch(MAPPER::fromDb);
    }

    public List<Long> getBannersWithTurboApps(int shard, Collection<Long> campaignIds) {
        return dslContextProvider.ppc(shard)
                .select(BANNER_TURBO_APPS.BID)
                .from(BANNER_TURBO_APPS)
                .join(BANNERS).on(BANNER_TURBO_APPS.BID.eq(BANNERS.BID))
                .where(BANNERS.CID.in(campaignIds))
                .fetch(BANNER_TURBO_APPS.BID);
    }

    /**
     * Привязка turboApp к баннеру
     */
    public void addOrUpdateBannerTurboApps(int shard, Collection<OldBannerTurboApp> bannerTurboApps) {
        if(bannerTurboApps.isEmpty()) {
            return;
        }
        InsertHelper<BannerTurboAppsRecord> helper = new InsertHelper<>(dslContextProvider.ppc(shard), BANNER_TURBO_APPS);
        helper.addAll(MAPPER, bannerTurboApps);
        if (helper.hasAddedRecords()) {
            helper.onDuplicateKeyUpdate()
                    .set(BANNER_TURBO_APPS.TURBO_APP_INFO_ID, MySQLDSL.values(BANNER_TURBO_APPS.TURBO_APP_INFO_ID))
                    .set(BANNER_TURBO_APPS.BANNER_TURBO_APP_TYPE, MySQLDSL.values(BANNER_TURBO_APPS.BANNER_TURBO_APP_TYPE))
                    .set(BANNER_TURBO_APPS.CONTENT, MySQLDSL.values(BANNER_TURBO_APPS.CONTENT));
        }
        helper.executeIfRecordsAdded();
    }

    public <T extends OldBannerWithPrice> void updateBannerTurboAppTypes(Collection<AppliedChanges<T>> appliedChanges,
                                                                         DSLContext context) {
        JooqUpdateBuilder<BannerTurboAppsRecord, T> updateBuilder =
                new JooqUpdateBuilder<>(BANNER_TURBO_APPS.BID, appliedChanges);

        updateBuilder.processProperty(T.ID, BANNER_TURBO_APPS.BID);
        updateBuilder.processProperty(
                T.BANNER_PRICE,
                BANNER_TURBO_APPS.BANNER_TURBO_APP_TYPE,
                price -> BannerTurboAppType.toSource(countBannerTurboAppType(price)));

        context
                .update(BANNER_TURBO_APPS)
                .set(updateBuilder.getValues())
                .where(BANNER_TURBO_APPS.BID.in(updateBuilder.getChangedIds()))
                .execute();
    }

}
