package ru.yandex.direct.core.entity.banner.repository.old;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import one.util.streamex.StreamEx;
import org.jooq.DSLContext;
import org.jooq.util.mysql.MySQLDSL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.banner.model.old.OldBannerTurboGallery;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerWithTurboGalleryHref;
import ru.yandex.direct.dbschema.ppc.tables.records.BannerTurboGalleriesRecord;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;
import ru.yandex.direct.jooqmapper.JooqModelToDbMapper;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;

import static java.util.Collections.singleton;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.TextBannerMapperProvider.getTextBannerMapper;
import static ru.yandex.direct.dbschema.ppc.tables.BannerTurboGalleries.BANNER_TURBO_GALLERIES;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@Repository
@Deprecated
public class OldBannerTurboGalleriesRepository {

    private final DslContextProvider dslContextProvider;
    private final ShardHelper shardHelper;
    private static final JooqMapperWithSupplier<OldBannerTurboGallery> TURBO_GALLERY_MAPPER = createMapper();

    @Autowired
    public OldBannerTurboGalleriesRepository(DslContextProvider dslContextProvider, ShardHelper shardHelper) {
        this.dslContextProvider = dslContextProvider;
        this.shardHelper = shardHelper;
    }

    public Map<Long, String> getTurboGalleriesByBannerIds(int shard, Collection<Long> bannerIds) {
        return dslContextProvider.ppc(shard)
                .select(BANNER_TURBO_GALLERIES.BID, BANNER_TURBO_GALLERIES.TURBO_GALLERY_HREF)
                .from(BANNER_TURBO_GALLERIES)
                .where(BANNER_TURBO_GALLERIES.BID.in(bannerIds))
                .fetchMap(BANNER_TURBO_GALLERIES.BID, BANNER_TURBO_GALLERIES.TURBO_GALLERY_HREF);
    }

    private Map<Long, String> getAllTurboGalleries(int shard) {
        return dslContextProvider.ppc(shard)
                .select(TURBO_GALLERY_MAPPER.getFieldsToRead())
                .from(BANNER_TURBO_GALLERIES)
                .fetchMap(BANNER_TURBO_GALLERIES.BID, BANNER_TURBO_GALLERIES.TURBO_GALLERY_HREF);
    }

    public Map<Long, String> getAllTurboGalleries() {
        Map<Long, String> result = new HashMap<>();
        shardHelper.forEachShard(shard -> result.putAll(getAllTurboGalleries(shard)));
        return result;
    }

    /**
     * Метод должен вызываться только из внутреннего отчета {@code BannerTurboGalleryUpdateTool}
     * В остальных случаях использовать метод {@link #addOrUpdateBannerTurboGallery(Collection, DSLContext)}
     */
    public void addOrUpdateBannerTurboGallery(OldBannerTurboGallery bannerTurboGallery) {
        int shard = shardHelper.getShardByBannerId(bannerTurboGallery.getBannerId());
        InsertHelper<BannerTurboGalleriesRecord> insertHelper = new InsertHelper<>(dslContextProvider.ppc(shard),
                BANNER_TURBO_GALLERIES);
        insertHelper.add(TURBO_GALLERY_MAPPER, bannerTurboGallery);
        if (insertHelper.hasAddedRecords()) {
            insertHelper.onDuplicateKeyUpdate()
                    .set(BANNER_TURBO_GALLERIES.BID, bannerTurboGallery.getBannerId())
                    .set(BANNER_TURBO_GALLERIES.TURBO_GALLERY_HREF, bannerTurboGallery.getTurboGalleryHref())
                    .execute();
        }
    }

    private static JooqMapperWithSupplier<OldBannerTurboGallery> createMapper() {
        return JooqMapperWithSupplierBuilder.builder(OldBannerTurboGallery::new)
                .map(property(OldBannerTurboGallery.BANNER_ID, BANNER_TURBO_GALLERIES.BID))
                .map(property(OldBannerTurboGallery.TURBO_GALLERY_HREF, BANNER_TURBO_GALLERIES.TURBO_GALLERY_HREF))
                .build();
    }

    public void deleteBannerTurboGallery(int shard, Long bannerId) {
        deleteBannerTurboGalleryHref(singleton(bannerId), dslContextProvider.ppc(shard));
    }

    public <B extends OldBannerWithTurboGalleryHref> void addOrUpdateBannerTurboGallery(Collection<B> banners,
                                                                                        DSLContext context) {
        //noinspection unchecked
        JooqModelToDbMapper<B> mapper = (JooqModelToDbMapper) getTextBannerMapper();
        List<B> bannersToUpdate = StreamEx.of(banners)
                .filter(banner -> banner.getTurboGalleryHref() != null)
                .toList();
        InsertHelper<BannerTurboGalleriesRecord> insertHelper =
                new InsertHelper<>(context, BANNER_TURBO_GALLERIES)
                        .addAll(mapper, bannersToUpdate);
        if (insertHelper.hasAddedRecords()) {
            insertHelper.onDuplicateKeyUpdate()
                    .set(BANNER_TURBO_GALLERIES.TURBO_GALLERY_HREF,
                            MySQLDSL.values(BANNER_TURBO_GALLERIES.TURBO_GALLERY_HREF));
        }
        insertHelper.executeIfRecordsAdded();
    }

    public void deleteBannerTurboGalleryHref(Collection<Long> bannerIds, DSLContext context) {
        if (bannerIds.isEmpty()) {
            return;
        }
        context
                .deleteFrom(BANNER_TURBO_GALLERIES)
                .where(BANNER_TURBO_GALLERIES.BID.in(bannerIds))
                .execute();
    }

}
