package ru.yandex.direct.core.entity.banner.repository.old;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;

import one.util.streamex.StreamEx;
import org.jooq.DSLContext;
import org.jooq.util.mysql.MySQLDSL;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.banner.model.old.OldBannerWithTurboLanding;
import ru.yandex.direct.core.entity.banner.model.old.OldTextBanner;
import ru.yandex.direct.core.entity.banner.repository.old.container.AddOrUpdateAndDeleteContainer;
import ru.yandex.direct.core.entity.banner.turbolanding.model.OldBannerTurboLandingParams;
import ru.yandex.direct.dbschema.ppc.tables.records.BannerTurbolandingParamsRecord;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.utils.FunctionalUtils;

import static ru.yandex.direct.core.entity.banner.repository.old.mapper.turbolanding.BannerTurboLandingParamsMapperProvider.getBannerTurboLandingParamsMapper;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_TURBOLANDING_PARAMS;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

@Repository
@Deprecated
public class OldBannerTurbolandingParamsRepository {

    public <B extends OldBannerWithTurboLanding> void addOrUpdateBannerTurbolandingParams(
            Collection<B> banners, DSLContext context) {
        InsertHelper<BannerTurbolandingParamsRecord> insertHelper =
                new InsertHelper<>(context, BANNER_TURBOLANDING_PARAMS);

        StreamEx.of(banners)
                .filter(b -> b.getTurboLandingParams() != null)
                .forEach(b -> {
                    b.getTurboLandingParams().withBannerId(b.getId());
                    insertHelper.add(getBannerTurboLandingParamsMapper(), b.getTurboLandingParams()).newRecord();
                });

        if (insertHelper.hasAddedRecords()) {
            insertHelper.onDuplicateKeyUpdate()
                    .set(BANNER_TURBOLANDING_PARAMS.HREF_PARAMS,
                            MySQLDSL.values(BANNER_TURBOLANDING_PARAMS.HREF_PARAMS));
            insertHelper.execute();
        }
    }

    public <B extends OldBannerWithTurboLanding> void deleteBannerTurbolandingParams(
            Collection<B> banners, DSLContext context) {
        Set<Long> idsToDelete = FunctionalUtils.listToSet(banners, OldBannerWithTurboLanding::getId);
        if (idsToDelete.isEmpty()) {
            return;
        }
        context.deleteFrom(BANNER_TURBOLANDING_PARAMS)
                .where(BANNER_TURBOLANDING_PARAMS.BID.in(idsToDelete))
                .execute();
    }

    public <B extends OldBannerWithTurboLanding> AddOrUpdateAndDeleteContainer<B> prepareBannerTurboLandingParamsUpdateContainer(
            Collection<AppliedChanges<B>> appliedChangesCollection) {
        AddOrUpdateAndDeleteContainer<B> bannerTurbolandingParamsUpdateContainer =
                new AddOrUpdateAndDeleteContainer<>();

        for (AppliedChanges<B> appliedChanges : appliedChangesCollection) {
            if (appliedChanges.changed(B.TURBO_LANDING_PARAMS)) {
                if (appliedChanges.getNewValue(B.TURBO_LANDING_PARAMS) == null) {
                    bannerTurbolandingParamsUpdateContainer.markForDeletion(appliedChanges.getModel());
                } else {
                    String oldValue = ifNotNull(appliedChanges.getOldValue(OldTextBanner.TURBO_LANDING_PARAMS),
                            OldBannerTurboLandingParams::getHrefParams);
                    String newValue = ifNotNull(appliedChanges.getNewValue(OldTextBanner.TURBO_LANDING_PARAMS),
                            OldBannerTurboLandingParams::getHrefParams);
                    if (!Objects.equals(oldValue, newValue)) {
                        bannerTurbolandingParamsUpdateContainer.markForAddOrUpdate(appliedChanges.getModel());
                    }
                }
            }
        }
        return bannerTurbolandingParamsUpdateContainer;
    }
}
