package ru.yandex.direct.core.entity.banner.repository.old;

import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.types.ULong;
import org.jooq.types.UNumber;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.common.util.RepositoryUtils;
import ru.yandex.direct.core.entity.contentpromotionvideo.model.ContentPromotionVideo;
import ru.yandex.direct.dbschema.ppc.enums.BannersStatusmoderate;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;
import static ru.yandex.direct.dbschema.ppc.tables.BannersContentPromotionVideo.BANNERS_CONTENT_PROMOTION_VIDEO;
import static ru.yandex.direct.dbschema.ppc.tables.ContentPromotionVideo.CONTENT_PROMOTION_VIDEO;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;
import static ru.yandex.direct.jooqmapper.write.WriterBuilders.fromPropertyToField;

/**
 * Репозиторий для работы с таблицей ppc.content_promotion_video
 */
@Repository
@ParametersAreNonnullByDefault
@Deprecated
public class OldContentPromotionVideoRepository {

    protected final DslContextProvider dslContextProvider;
    protected final ShardHelper shardHelper;

    public static final JooqMapperWithSupplier<ContentPromotionVideo> CONTENT_PROMOTION_VIDEO_JOOQ_MAPPER =
            JooqMapperWithSupplierBuilder.builder(ContentPromotionVideo::new)
                    .map(property(ContentPromotionVideo.CONTENT_PROMOTION_VIDEO_ID,
                            CONTENT_PROMOTION_VIDEO.CONTENT_PROMOTION_VIDEO_ID))
                    .map(property(ContentPromotionVideo.CLIENT_ID, CONTENT_PROMOTION_VIDEO.CLIENT_ID))
                    .map(property(ContentPromotionVideo.VIDEO_HREF, CONTENT_PROMOTION_VIDEO.VIDEO_HREF))
                    .map(convertibleProperty(ContentPromotionVideo.VIDEO_HREF_HASH,
                            CONTENT_PROMOTION_VIDEO.VIDEO_HREF_HASH,
                            UNumber::toBigInteger, ULong::valueOf))
                    .map(property(ContentPromotionVideo.VIDEO_PREVIEW_URL, CONTENT_PROMOTION_VIDEO.VIDEO_PREVIEW_URL))
                    .map(property(ContentPromotionVideo.VIDEO_METADATA, CONTENT_PROMOTION_VIDEO.VIDEO_METADATA))
                    .map(convertibleProperty(ContentPromotionVideo.VIDEO_METADATA_HASH,
                            CONTENT_PROMOTION_VIDEO.VIDEO_METADATA_HASH,
                            UNumber::toBigInteger, ULong::valueOf))
                    .map(property(ContentPromotionVideo.VIDEO_METADATA_CREATE_TIME,
                            CONTENT_PROMOTION_VIDEO.VIDEO_METADATA_CREATE_TIME))
                    .map(convertibleProperty(ContentPromotionVideo.IS_INACCESSIBLE,
                            CONTENT_PROMOTION_VIDEO.IS_INACCESSIBLE,
                            RepositoryUtils::booleanFromLong, RepositoryUtils::booleanToLong))

                    .writeField(CONTENT_PROMOTION_VIDEO.VIDEO_METADATA_MODIFY_TIME,
                            fromPropertyToField(ContentPromotionVideo.VIDEO_METADATA_MODIFY_TIME)
                                    .by(RepositoryUtils::zeroableDateTimeToDb))
                    .readProperty(ContentPromotionVideo.VIDEO_METADATA_MODIFY_TIME,
                            fromField(CONTENT_PROMOTION_VIDEO.VIDEO_METADATA_MODIFY_TIME))

                    .writeField(CONTENT_PROMOTION_VIDEO.VIDEO_METADATA_REFRESH_TIME,
                            fromPropertyToField(ContentPromotionVideo.VIDEO_METADATA_REFRESH_TIME)
                                    .by(RepositoryUtils::zeroableDateTimeToDb))
                    .readProperty(ContentPromotionVideo.VIDEO_METADATA_REFRESH_TIME,
                            fromField(CONTENT_PROMOTION_VIDEO.VIDEO_METADATA_REFRESH_TIME))
                    .build();

    protected final Set<Field<?>> allFields;

    public OldContentPromotionVideoRepository(DslContextProvider dslContextProvider, ShardHelper shardHelper) {
        this.dslContextProvider = dslContextProvider;
        this.shardHelper = shardHelper;

        allFields = CONTENT_PROMOTION_VIDEO_JOOQ_MAPPER.getFieldsToRead();
    }

    /**
     * Получает наборы id-шников баннеров (не черновиков) по id видео-контента, к ним привязанного. Нужно, например,
     * для обновления баннеров при обновлении видео-контента.
     *
     * @param shard                    обрабатываемый шард
     * @param contentPromotionVideoIds набор id видео-контента
     * @return мапа (id видео-контента) - (список id баннеров (не черновиков), к которому оно привязано)
     */
    public Map<Long, List<Long>> getNonDraftBannerIdsByVideoIds(int shard, List<Long> contentPromotionVideoIds) {
        return dslContextProvider.ppc(shard)
                .select(BANNERS_CONTENT_PROMOTION_VIDEO.CONTENT_PROMOTION_VIDEO_ID,
                        BANNERS_CONTENT_PROMOTION_VIDEO.BID)
                .from(BANNERS_CONTENT_PROMOTION_VIDEO)
                .join(BANNERS).on(BANNERS.BID.eq(BANNERS_CONTENT_PROMOTION_VIDEO.BID))
                .where(BANNERS_CONTENT_PROMOTION_VIDEO.CONTENT_PROMOTION_VIDEO_ID.in(contentPromotionVideoIds))
                .and(BANNERS.STATUS_MODERATE.ne(BannersStatusmoderate.New))
                .fetchGroups(BANNERS_CONTENT_PROMOTION_VIDEO.CONTENT_PROMOTION_VIDEO_ID,
                        BANNERS_CONTENT_PROMOTION_VIDEO.BID);
    }

}
