package ru.yandex.direct.core.entity.banner.repository.old;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.jooq.DSLContext;
import org.jooq.util.mysql.MySQLDSL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.old.Image;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerWithImage;
import ru.yandex.direct.core.entity.banner.model.old.StatusImageModerate;
import ru.yandex.direct.dbschema.ppc.tables.records.ImagesRecord;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;

import static ru.yandex.direct.core.entity.banner.repository.old.mapper.ImageMapperProvider.getImageMapper;
import static ru.yandex.direct.dbschema.ppc.tables.Images.IMAGES;

/**
 * Класс для разгрузки {@link OldBannerRepository} –
 * делегат, инкапсулирующий обработку изображений графических объявлений,
 * табилца {@link ru.yandex.direct.dbschema.ppc.tables.Images}.
 */
@Component
@ParametersAreNonnullByDefault
@Deprecated
public class OldImageRepository {

    private final ShardHelper shardHelper;

    private final JooqMapperWithSupplier<Image> imageMapper;

    @Autowired
    public OldImageRepository(ShardHelper shardHelper) {
        this.shardHelper = shardHelper;

        this.imageMapper = getImageMapper();
    }

    /**
     * Сохранить объявления в базу.
     * <p>
     * Перед сохранением генерируются id для изображений, у которых id нет; а также всем
     * изображениям проставляются id баннера, группы, кампании.
     *
     * @param banners список графических объявлений
     * @param context DSL контекст jooq
     * @param <B>     тип баннеров
     */
    public <B extends OldBannerWithImage> void addOrUpdateImage(Collection<B> banners, DSLContext context) {
        // в новых баннерах см. BannerWithImageRepositoryTypeSupport
        generateAndSetNewImageIdsIfAbsent(banners);
        banners.forEach(this::setImageBidPidCid);

        InsertHelper<ImagesRecord> insertHelper = new InsertHelper<>(context, IMAGES)
                .addAll(imageMapper, banners, B::getImage, b -> b.getImage() != null);

        if (insertHelper.hasAddedRecords()) {
            insertHelper.onDuplicateKeyUpdate()
                    .set(IMAGES.STATUS_MODERATE, MySQLDSL.values(IMAGES.STATUS_MODERATE))
                    .set(IMAGES.IMAGE_HASH, MySQLDSL.values(IMAGES.IMAGE_HASH));
        }

        insertHelper.executeIfRecordsAdded();
    }

    /**
     * отправка изображений на модерацию
     */
    public void setStatusModerate(DSLContext context, Collection<Long> imageIds, StatusImageModerate status) {
        if (imageIds.isEmpty()) {
            return;
        }

        context
                .update(IMAGES)
                .set(IMAGES.STATUS_MODERATE, StatusImageModerate.toSource(status))
                .where(IMAGES.IMAGE_ID.in(imageIds))
                .execute();
    }

    /**
     * Генерировать новые id для image, если не заданы, и проставить.
     *
     * @param banners список графических баннеров
     */
    private <B extends OldBannerWithImage> void generateAndSetNewImageIdsIfAbsent(Collection<B> banners) {
        List<Image> imagesWithoutId = StreamEx.of(banners)
                .map(OldBannerWithImage::getImage)
                .nonNull()
                .filter(img -> img.getId() == null)
                .toList();
        List<Long> ids = shardHelper.generateImageIds(imagesWithoutId.size());
        StreamEx.of(imagesWithoutId).zipWith(ids.stream())
                .forKeyValue(Image::setId);
    }

    private void setImageBidPidCid(OldBannerWithImage banner) {
        Image image = banner.getImage();
        if (image == null) {
            return;
        }
        // изображение внутри баннера должно принадлежать этому баннеру
        image.setCampaignId(banner.getCampaignId());
        image.setAdGroupId(banner.getAdGroupId());
        image.setBannerId(banner.getId());
    }

    // перенесено в BannerImageRepository
    public Map<Long, List<Long>> getImageIdsByBannerIds(DSLContext context, Collection<Long> bannerIds) {
        return context
                .select(IMAGES.BID, IMAGES.IMAGE_ID).from(IMAGES)
                .where(IMAGES.BID.in(bannerIds))
                .fetchGroups(IMAGES.BID, IMAGES.IMAGE_ID);
    }
}
