package ru.yandex.direct.core.entity.banner.repository.old.container;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import one.util.streamex.EntryStream;

import ru.yandex.direct.core.entity.banner.model.old.OldBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerPixel;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerWithPixels;
import ru.yandex.direct.model.ModelWithId;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

/**
 * DTO, содержащий информацию о пикселях {@link OldBannerPixel},
 * которые нужно добавить, а также связях пикселей с баннерами,
 * которые нужно разорвать.
 */
@ParametersAreNonnullByDefault
@Deprecated
public class BannerPixelsUpdateContainer {

    private final List<OldBannerPixel> bannerPixelsToAdd = new ArrayList<>();
    private final Multimap<OldBannerWithPixels, OldBannerPixel> bannerPixelsToDelete = ArrayListMultimap.create();

    /**
     * Добавить пиксели в список подлежащих добавлению.
     *
     * @param pixels коллекция {@link OldBannerPixel}
     */
    public void markForAdd(Collection<OldBannerPixel> pixels) {
        bannerPixelsToAdd.addAll(pixels);
    }

    /**
     * Добавить баннер с пикселями в список связей, которые нужно удалить
     *
     * @param banner баннер с пикселями
     * @param pixels удаляемые пиксели
     */
    public void markPixelsForDeletion(OldBannerWithPixels banner, Collection<OldBannerPixel> pixels) {
        bannerPixelsToDelete.putAll(banner, pixels);
    }

    /**
     * @return Список пикселей, отмеченных подлежащими добавлению.
     */
    public List<OldBannerPixel> getBannerPixelsToAdd() {
        return new ArrayList<>(bannerPixelsToAdd);
    }

    /**
     * Получить связи id баннеров к пикселям, которые нужно удалить
     *
     * @return Map: {@link OldBanner#id} -> список {@link OldBannerPixel#pixelUrl}.
     */
    public Map<Long, List<String>> getBannerPixelsToDelete() {
        return EntryStream.of(bannerPixelsToDelete.asMap())
                .mapKeys(ModelWithId::getId)
                .mapValues(pixels -> mapList(pixels, OldBannerPixel::getPixelUrl))
                .toMap();
    }
}
