package ru.yandex.direct.core.entity.banner.repository.old.container;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import one.util.streamex.EntryStream;

import ru.yandex.direct.core.entity.banner.model.BannerAddition;
import ru.yandex.direct.core.entity.banner.model.old.OldBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerWithCallouts;
import ru.yandex.direct.model.ModelWithId;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

/**
 * DTO, содержащий информацию об уточнениях (дополнениях баннеров, {@link BannerAddition}),
 * которые нужно добавить/обновить, а также связях коллаутов с баннерами,
 * которые нужно разорвать.
 */
@ParametersAreNonnullByDefault
@Deprecated
public class CalloutsUpdateContainer {

    private final List<BannerAddition> bannersCalloutsToAddOrUpdate = new ArrayList<>();
    private final Multimap<OldBannerWithCallouts, BannerAddition> bannersCalloutsToDelete = ArrayListMultimap.create();

    /**
     * Добавить уточнения в список подлежащих добавлению или обновлению.
     *
     * @param callouts коллекция {@link BannerAddition}
     */
    public void markForAddOuUpdate(Collection<BannerAddition> callouts) {
        bannersCalloutsToAddOrUpdate.addAll(callouts);
    }

    /**
     * Добавить баннер с уточнениями в список связей, которые нужно разорвать (удалить).
     *
     * @param banner   баннер с уточнениями
     * @param callouts отвязываемые уточнения
     */
    public void markCalloutsForDeletion(OldBannerWithCallouts banner, Collection<BannerAddition> callouts) {
        bannersCalloutsToDelete.putAll(banner, callouts);
    }

    /**
     * @return Список уточнений, отмеченных подлежащими добавлению/обновлению.
     */
    public List<BannerAddition> getBannersCalloutsToAddOrUpdate() {
        return new ArrayList<>(bannersCalloutsToAddOrUpdate);
    }

    /**
     * Получить связи id баннеров к id уточнений, которые нужно разорвать (удалить).
     *
     * @return Map: {@link OldBanner#id} -> список {@link BannerAddition#id}.
     */
    public Map<Long, List<Long>> getBannersCalloutsToDelete() {
        return EntryStream.of(bannersCalloutsToDelete.asMap())
                .mapKeys(ModelWithId::getId)
                .mapValues(callouts -> mapList(callouts, ModelWithId::getId))
                .toMap();
    }
}
