package ru.yandex.direct.core.entity.banner.repository.old.filter;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Record;
import org.jooq.SelectConditionStep;
import org.jooq.SelectJoinStep;
import org.jooq.impl.DSL;

import static ru.yandex.direct.dbschema.ppc.tables.Banners.BANNERS;

/**
 * Применяется в случаях, когда необходимо сделать условие выборки
 * по id различных баннеров, групп, кампаний или креативов
 */
@ParametersAreNonnullByDefault
public class BannerIdFilter extends IdFilter {

    private final Collection<Long> bannerIds;

    BannerIdFilter(Collection<Long> bannerIds) {
        this.bannerIds = bannerIds;
    }

    @Override
    public <R extends Record> SelectConditionStep<R> addWhereClause(SelectJoinStep<R> selectJoinStep) {
        selectJoinStep.where(DSL.condition(true));
        return selectJoinStep.where(BANNERS.BID.in(bannerIds));
    }

    @Override
    Collection<Long> ids() {
        return bannerIds;
    }

}
