package ru.yandex.direct.core.entity.banner.repository.old.filter;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class BannersIdFilterFactory {

    private BannersIdFilterFactory() {
    }

    public static IdFilter bannerIdsFilter(Collection<Long> bannerIds) {
        return new BannerIdFilter(bannerIds);
    }

    public static IdFilter groupIdsFilter(Collection<Long> groupIds) {
        return new GroupIdFilter(groupIds);
    }

    public static IdFilter campaignIdsFilter(Collection<Long> campaignIds) {
        return new CampaignIdFilter(campaignIds);
    }

    public static IdFilter creativeIdsFilter(Collection<Long> creativeIds, Long clientId) {
        return new CreativeIdFilter(creativeIds, clientId);
    }

}
