package ru.yandex.direct.core.entity.banner.repository.old.filter;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Record;
import org.jooq.SelectConditionStep;
import org.jooq.SelectJoinStep;

import static ru.yandex.direct.dbschema.ppc.tables.Banners.BANNERS;

/**
 * Применяется в случаях, когда необходимо сделать условие выборки
 * по id различных баннеров, групп, кампаний или креативов
 */
@ParametersAreNonnullByDefault
public class CampaignIdFilter extends IdFilter {

    private final Collection<Long> campaignIds;

    CampaignIdFilter(Collection<Long> campaignIds) {
        this.campaignIds = campaignIds;
    }

    @Override
    public <R extends Record> SelectConditionStep<R> addWhereClause(SelectJoinStep<R> selectJoinStep) {
        return selectJoinStep.where(BANNERS.CID.in(campaignIds));
    }

    @Override
    Collection<Long> ids() {
        return campaignIds;
    }

}
