package ru.yandex.direct.core.entity.banner.repository.old.filter;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Record;
import org.jooq.SelectConditionStep;
import org.jooq.SelectJoinStep;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS_PERFORMANCE;
import static ru.yandex.direct.dbschema.ppc.tables.Banners.BANNERS;
import static ru.yandex.direct.dbschema.ppc.tables.Campaigns.CAMPAIGNS;

/**
 * Применяется в случаях, когда необходимо сделать условие выборки
 * по id различных баннеров, групп, кампаний или креативов
 */
@ParametersAreNonnullByDefault
public class CreativeIdFilter extends IdFilter {

    private final Collection<Long> creativeIds;
    private final Long clientId;

    CreativeIdFilter(Collection<Long> creativeIds, Long clientId) {
        this.creativeIds = creativeIds;
        this.clientId = clientId;
    }

    @Override
    public <R extends Record> SelectConditionStep<R> addWhereClause(SelectJoinStep<R> selectJoinStep) {
        return selectJoinStep
                .join(CAMPAIGNS)
                .on(CAMPAIGNS.CID.eq(BANNERS.CID))
                .and(CAMPAIGNS.CLIENT_ID.eq(clientId))
                .where(BANNERS_PERFORMANCE.CREATIVE_ID.in(creativeIds));
    }

    @Override
    Collection<Long> ids() {
        return creativeIds;
    }

}
