package ru.yandex.direct.core.entity.banner.repository.old.filter;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Record;
import org.jooq.SelectConditionStep;
import org.jooq.SelectJoinStep;

import static com.google.common.base.Preconditions.checkArgument;

/**
 * Применяется в случаях, когда необходимо сделать условие выборки
 * по id различных баннеров, групп, кампаний или креативов.
 */
@ParametersAreNonnullByDefault
public abstract class IdFilter {

    /**
     * Применить фильтр к Jooq-овому select-запросу путём добавления
     * к нему соответствующего выражения {@code where}.
     * <p>
     * Если в фильтре пустая коллекция, будет брошено исключение.
     *
     * @param selectJoinStep select-запрос на стадии после join-ов,
     *                       когда синтаксически корректно добавить
     *                       {@code where ...}
     * @return Следующий шаг построения запроса – {@link SelectConditionStep}.
     */
    public <R extends Record> SelectConditionStep<R> apply(SelectJoinStep<R> selectJoinStep) {
        // предотвращаем появление пустого массива в запросе, вроде 'WHERE ... IN ()'
        checkArgument(!ids().isEmpty(), "collection of ids must not be empty");

        return addWhereClause(selectJoinStep);
    }

    public abstract <R extends Record> SelectConditionStep<R> addWhereClause(SelectJoinStep<R> selectJoinStep);

    abstract Collection<Long> ids();
}
