package ru.yandex.direct.core.entity.banner.repository.old.mapper;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.banner.model.ButtonAction;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerButton;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerButtonStatusModerate;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_BUTTONS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@ParametersAreNonnullByDefault
@Deprecated
public class BannerButtonsMapperProvider {

    private static final JooqMapperWithSupplier<OldBannerButton> MAPPER = createMapper();

    private BannerButtonsMapperProvider() {
    }

    /**
     * @return {@link JooqMapperWithSupplier} для кнопок у баннеров.
     */
    public static JooqMapperWithSupplier<OldBannerButton> getBannerButtonsMapper() {
        return MAPPER;
    }

    private static JooqMapperWithSupplier<OldBannerButton> createMapper() {
        return JooqMapperWithSupplierBuilder.builder(OldBannerButton::new)
                .map(property(OldBannerButton.BANNER_ID, BANNER_BUTTONS.BID))
                .map(convertibleProperty(OldBannerButton.ACTION, BANNER_BUTTONS.KEY,
                        ButtonAction::fromSource, ButtonAction::toSource))
                .map(property(OldBannerButton.CAPTION, BANNER_BUTTONS.CAPTION))
                .map(property(OldBannerButton.HREF, BANNER_BUTTONS.HREF))
                .map(convertibleProperty(OldBannerButton.STATUS_MODERATE, BANNER_BUTTONS.STATUS_MODERATE,
                        OldBannerButtonStatusModerate::fromSource, OldBannerButtonStatusModerate::toSource))
                .build();
    }
}
