package ru.yandex.direct.core.entity.banner.repository.old.mapper;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.banner.model.old.OldBannerCreative;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerCreativeStatusModerate;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS_PERFORMANCE;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@ParametersAreNonnullByDefault
@Deprecated
public class BannerCreativeMapperProvider {

    private static final JooqMapperWithSupplier<OldBannerCreative> MAPPER = createMapper();

    private BannerCreativeMapperProvider() {
    }

    /**
     * @return {@link JooqMapperWithSupplier} для баннер-креативов.
     */
    public static JooqMapperWithSupplier<OldBannerCreative> getBannerCreativeMapper() {
        return MAPPER;
    }

    private static JooqMapperWithSupplier<OldBannerCreative> createMapper() {
        return JooqMapperWithSupplierBuilder.builder(OldBannerCreative::new)
                .map(property(OldBannerCreative.ID, BANNERS_PERFORMANCE.BANNER_CREATIVE_ID))
                .map(property(OldBannerCreative.BANNER_ID, BANNERS_PERFORMANCE.BID))
                .map(property(OldBannerCreative.AD_GROUP_ID, BANNERS_PERFORMANCE.PID))
                .map(property(OldBannerCreative.CAMPAIGN_ID, BANNERS_PERFORMANCE.CID))
                .map(property(OldBannerCreative.EXTRACTED_TEXT, BANNERS_PERFORMANCE.EXTRACTED_TEXT))
                .map(property(OldBannerCreative.CREATIVE_ID, BANNERS_PERFORMANCE.CREATIVE_ID))
                .map(convertibleProperty(OldBannerCreative.STATUS_MODERATE, BANNERS_PERFORMANCE.STATUS_MODERATE,
                        OldBannerCreativeStatusModerate::fromSource, OldBannerCreativeStatusModerate::toSource))
                .build();
    }

}
