package ru.yandex.direct.core.entity.banner.repository.old.mapper;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.banner.model.ImageType;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerImage;
import ru.yandex.direct.core.entity.banner.model.old.OldStatusBannerImageModerate;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;

import static ru.yandex.direct.dbschema.ppc.tables.BannerImages.BANNER_IMAGES;
import static ru.yandex.direct.dbschema.ppc.tables.BannerImagesFormats.BANNER_IMAGES_FORMATS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;

@ParametersAreNonnullByDefault
@Deprecated
public class BannerImageMapperProvider {

    private static final JooqMapperWithSupplier<OldBannerImage> MAPPER = createBannerImageMapper();

    private BannerImageMapperProvider() {
    }

    public static JooqMapperWithSupplier<OldBannerImage> getBannerImageMapper() {
        return MAPPER;
    }

    private static JooqMapperWithSupplier<OldBannerImage> createBannerImageMapper() {
        return JooqMapperWithSupplierBuilder.builder(OldBannerImage::new)
                .map(property(OldBannerImage.ID, BANNER_IMAGES.IMAGE_ID))
                .map(property(OldBannerImage.IMAGE_HASH, BANNER_IMAGES.IMAGE_HASH))
                .map(property(OldBannerImage.NAME, BANNER_IMAGES.NAME))
                .map(property(OldBannerImage.BANNER_ID, BANNER_IMAGES.BID))
                .map(property(OldBannerImage.BS_BANNER_ID, BANNER_IMAGES.BANNER_ID))
                .map(convertibleProperty(OldBannerImage.STATUS_MODERATE, BANNER_IMAGES.STATUS_MODERATE,
                        OldStatusBannerImageModerate::fromSource, OldStatusBannerImageModerate::toSource))
                .map(convertibleProperty(OldBannerImage.STATUS_SHOW, BANNER_IMAGES.STATUS_SHOW,
                        BannerImageMappings::imageStatusShowFromDb, BannerImageMappings::imageStatusShowToDb))
                .map(property(OldBannerImage.DATE_ADDED, BANNER_IMAGES.DATE_ADDED))
                .readProperty(OldBannerImage.IMAGE_TYPE, fromField(BANNER_IMAGES_FORMATS.IMAGE_TYPE)
                        .by(ImageType::fromSource))
                .build();
    }

}
