package ru.yandex.direct.core.entity.banner.repository.old.mapper;

import java.util.Collection;
import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.old.InternalAdExtraInfo;
import ru.yandex.direct.core.entity.banner.model.old.InternalAdExtraInfoOnly;
import ru.yandex.direct.core.entity.banner.model.old.OldInternalBanner;
import ru.yandex.direct.core.entity.banner.model.old.TemplateVariable;
import ru.yandex.direct.dbschema.ppc.tables.records.BannersInternalRecord;
import ru.yandex.direct.dbschema.ppc.tables.records.BannersRecord;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;
import ru.yandex.direct.jooqmapperhelper.JooqUpdateBuilder;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.utils.JsonUtils;

import static java.util.Collections.emptyList;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.CommonBannerMapperProvider.createBannersCommonUpdateBuilder;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.CommonBannerMapperProvider.getCommonBannerMapper;
import static ru.yandex.direct.dbschema.ppc.tables.BannersInternal.BANNERS_INTERNAL;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.direct.jooqmapper.write.WriterBuilders.fromProperty;

@Component
@ParametersAreNonnullByDefault
@Deprecated
public class BannerInternalMapperProvider {
    private static final JavaType TEMPLATE_VARIABLES_TYPE = TypeFactory.defaultInstance()
            .constructCollectionType(List.class, TemplateVariable.class);

    private final JooqMapperWithSupplier<OldInternalBanner> mapper;
    private final JooqMapperWithSupplier<InternalAdExtraInfoOnly> extraInfoMapper;

    public BannerInternalMapperProvider() {
        mapper = createBannerInternalMapper();
        extraInfoMapper = createInternalAdExtraInfoOnlyMapper();
    }

    /**
     * @return {@link JooqMapperWithSupplier} для  внутренних объявлений {@link OldInternalBanner}.
     * @see CommonBannerMapperProvider
     */
    public JooqMapperWithSupplier<OldInternalBanner> getBannerInternalMapper() {
        return mapper;
    }


    public JooqMapperWithSupplier<InternalAdExtraInfoOnly> getInternalExtraInfoMapper() {
        return extraInfoMapper;
    }

    private JooqMapperWithSupplier<OldInternalBanner> createBannerInternalMapper() {
        JooqMapperWithSupplierBuilder<OldInternalBanner> mapperBuilder =
                JooqMapperWithSupplierBuilder.builder(getCommonBannerMapper(), OldInternalBanner::new)
                        .writeField(BANNERS_INTERNAL.BID, fromProperty(OldInternalBanner.ID));
        addInternalAdExtraInfoMapping(mapperBuilder);
        return mapperBuilder.build();
    }

    /**
     * Этот маппер нужен для чтения только тех данных баннера внутренней рекламы, которые дополняют общие поля баннера.
     * Предназначен для использования в grid-ах, для дополнения информации из Yt.
     */
    private JooqMapperWithSupplier<InternalAdExtraInfoOnly> createInternalAdExtraInfoOnlyMapper() {
        JooqMapperWithSupplierBuilder<InternalAdExtraInfoOnly> mapperBuilder =
                JooqMapperWithSupplierBuilder.builder(InternalAdExtraInfoOnly::new);
        addInternalAdExtraInfoMapping(mapperBuilder);
        return mapperBuilder.build();
    }

    private void addInternalAdExtraInfoMapping(
            JooqMapperBuilder<? extends InternalAdExtraInfo> mapperBuilder) {
        mapperBuilder
                .map(property(InternalAdExtraInfo.DESCRIPTION, BANNERS_INTERNAL.DESCRIPTION))
                .map(property(InternalAdExtraInfo.TEMPLATE_ID, BANNERS_INTERNAL.TEMPLATE_ID))
                .map(convertibleProperty(InternalAdExtraInfo.TEMPLATE_VARIABLES, BANNERS_INTERNAL.TEMPLATE_VARIABLES,
                        this::templateVariablesFromJson,
                        this::templateVariablesToJson)
                );
    }

    /**
     * @param appliedChanges изменения моделей при обновлении
     * @return {@link JooqUpdateBuilder} для внутренних объявлений {@link OldInternalBanner}.
     */
    public JooqUpdateBuilder<BannersRecord, OldInternalBanner> createInternalBannerUpdateBuilder(
            Collection<AppliedChanges<OldInternalBanner>> appliedChanges) {
        return createBannersCommonUpdateBuilder(appliedChanges);
    }


    public JooqUpdateBuilder<BannersInternalRecord, OldInternalBanner> createBannersInternalUpdateBuilder(
            Collection<AppliedChanges<OldInternalBanner>> changes) {
        JooqUpdateBuilder<BannersInternalRecord, OldInternalBanner> builder
                = new JooqUpdateBuilder<>(BANNERS_INTERNAL.BID, changes);

        builder.processProperty(OldInternalBanner.DESCRIPTION, BANNERS_INTERNAL.DESCRIPTION);
        builder.processProperty(OldInternalBanner.TEMPLATE_VARIABLES, BANNERS_INTERNAL.TEMPLATE_VARIABLES,
                this::templateVariablesToJson);
        return builder;
    }

    private List<TemplateVariable> templateVariablesFromJson(@Nullable String data) {
        if (data == null) {
            return emptyList();
        }
        return JsonUtils.fromJson(data, BannerInternalMapperProvider.TEMPLATE_VARIABLES_TYPE);
    }

    private String templateVariablesToJson(List<TemplateVariable> templateVariables) {
        return JsonUtils.toJson(templateVariables);
    }
}
